/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.imports;

import com.google.common.collect.Multimap;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public interface IOrganizeImportHelper {
    public Multimap<EClass, EReference> getTypeReferences();

    default public ImportRegionResult getImportRegion(XtextResource resource) {
        EObject root = (EObject)resource.getContents().get(0);
        TreeIterator it = root.eAllContents();
        int begin = Integer.MAX_VALUE;
        int end = 0;
        while (it.hasNext()) {
            ICompositeNode node;
            EObject object = (EObject)it.next();
            if (!(object instanceof Import) || (node = NodeModelUtils.findActualNodeFor((EObject)object)) == null) continue;
            begin = Math.min(begin, node.getOffset());
            end = Math.max(end, node.getEndOffset());
        }
        if (begin < end) {
            return new ImportRegionResult(begin, end - begin, false);
        }
        return null;
    }

    public QualifiedName getFullyQualifiedName(EObject var1);

    public List<QualifiedName> resolveFullyQualifiedName(String var1, EClass var2, Resource var3);

    public static class ImportRegionResult {
        private ITextRegion region;
        private boolean needNewLine;

        public ImportRegionResult(int offset, int length, boolean needNewLine) {
            this.region = new TextRegion(offset, length);
            this.needNewLine = needNewLine;
        }

        public ITextRegion getRegion() {
            return this.region;
        }

        public boolean isNeedNewLine() {
            return this.needNewLine;
        }
    }
}

