/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.scoping;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.etrice.core.common.scoping.StandardModelLocator;

public class RelativeFileURIHandler
extends URIHandlerImpl {
    private static final Logger LOG = Logger.getLogger(RelativeFileURIHandler.class);
    protected final XMLResource.URIHandler fallback;

    public static Map<Object, Object> addToOptions(Map<Object, Object> options) {
        options.put("URI_HANDLER", (Object)new RelativeFileURIHandler((XMLResource.URIHandler)options.get("URI_HANDLER")));
        return options;
    }

    public RelativeFileURIHandler() {
        this(null);
    }

    public RelativeFileURIHandler(XMLResource.URIHandler fallback) {
        this.fallback = fallback;
    }

    public URI resolve(URI uri) {
        if (this.resolve && this.baseURI != null && uri.isFile() && uri.hasRelativePath()) {
            URI baseFileURI = RelativeFileURIHandler.toFileURI(this.baseURI);
            URI fileURI = RelativeFileURIHandler.toFileURI(uri);
            URI resolvedFileURI = fileURI.resolve(baseFileURI, true);
            if (EMFPlugin.IS_ECLIPSE_RUNNING) {
                URI platURI = StandardModelLocator.getPlatformURI(resolvedFileURI);
                return platURI != null ? platURI : resolvedFileURI;
            }
            return resolvedFileURI;
        }
        return this.fallback != null ? this.fallback.resolve(uri) : uri;
    }

    public URI deresolve(URI uri) {
        if (this.resolve && this.baseURI != null) {
            URI baseFileURI = RelativeFileURIHandler.toFileURI(this.baseURI);
            URI fileURI = RelativeFileURIHandler.toFileURI(uri);
            URI relativeFileURI = fileURI.deresolve(baseFileURI, true, true, true);
            if (relativeFileURI.isFile() && relativeFileURI.hasRelativePath()) {
                return relativeFileURI;
            }
        }
        return this.fallback != null ? this.fallback.deresolve(uri) : uri;
    }

    private static URI toFileURI(URI uri) {
        if (uri.isFile()) {
            return uri;
        }
        if (uri.isPlatform()) {
            IPath path = null;
            if (uri.segmentCount() == 2) {
                path = ResourcesPlugin.getWorkspace().getRoot().getProject(uri.lastSegment()).getLocation();
            } else if (uri.segmentCount() > 2) {
                path = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(false))).getLocation();
            }
            if (path != null) {
                return URI.createFileURI((String)path.toOSString()).appendQuery(uri.query()).appendFragment(uri.fragment());
            }
        }
        LOG.error((Object)("unhandled uri " + String.valueOf(uri)));
        return uri;
    }
}

