/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.incquery.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;

public abstract class BasePConstraint
implements PConstraint {
    protected PBody pBody;
    private final Set<PVariable> affectedVariables;
    private final int sequentialID = nextID++;
    private static int nextID = 0;

    public BasePConstraint(PBody pBody, Set<PVariable> affectedVariables) {
        this.pBody = pBody;
        this.affectedVariables = new HashSet<PVariable>(affectedVariables);
        for (PVariable pVariable : affectedVariables) {
            pVariable.refer(this);
        }
        pBody.registerConstraint(this);
    }

    public String toString() {
        return "PC[" + this.getClass().getSimpleName() + ":" + this.toStringRest() + "]";
    }

    protected abstract String toStringRest();

    @Override
    public Set<PVariable> getAffectedVariables() {
        return this.affectedVariables;
    }

    @Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies(IQueryMetaContext context) {
        return Collections.emptyMap();
    }

    @Override
    public void replaceVariable(PVariable obsolete, PVariable replacement) {
        this.pBody.checkMutability();
        if (this.affectedVariables.remove(obsolete)) {
            this.affectedVariables.add(replacement);
            obsolete.unrefer(this);
            replacement.refer(this);
            this.doReplaceVariable(obsolete, replacement);
        }
    }

    protected abstract void doReplaceVariable(PVariable var1, PVariable var2);

    @Override
    public void delete() {
        this.pBody.checkMutability();
        for (PVariable pVariable : this.affectedVariables) {
            pVariable.unrefer(this);
        }
        this.pBody.unregisterConstraint(this);
    }

    @Override
    public void checkSanity() throws QueryProcessingException {
    }

    public PBody getPSystem() {
        return this.pBody;
    }

    @Override
    public int getMonotonousID() {
        return this.sequentialID;
    }
}

