package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.PackageOwnedTypeMatch;
import org.eclipse.incquery.uml.derivedfeatures.PackageOwnedTypeMatcher;

/**
 * A pattern-specific query specification that can instantiate PackageOwnedTypeMatcher in a type-safe way.
 * 
 * @see PackageOwnedTypeMatcher
 * @see PackageOwnedTypeMatch
 * 
 */
@SuppressWarnings("all")
public final class PackageOwnedTypeQuerySpecification extends BaseGeneratedEMFQuerySpecification<PackageOwnedTypeMatcher> {
  private PackageOwnedTypeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static PackageOwnedTypeQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected PackageOwnedTypeMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return PackageOwnedTypeMatcher.on(engine);
  }
  
  @Override
  public PackageOwnedTypeMatch newEmptyMatch() {
    return PackageOwnedTypeMatch.newEmptyMatch();
  }
  
  @Override
  public PackageOwnedTypeMatch newMatch(final Object... parameters) {
    return PackageOwnedTypeMatch.newMatch((org.eclipse.uml2.uml.Package) parameters[0], (org.eclipse.uml2.uml.Type) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static PackageOwnedTypeQuerySpecification INSTANCE = make();
    
    public static PackageOwnedTypeQuerySpecification make() {
      return new PackageOwnedTypeQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static PackageOwnedTypeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.packageOwnedType";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","temp2");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Package"),new PParameter("temp2", "org.eclipse.uml2.uml.Type"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_self = body.getOrCreateVariableByName("self");
      	PVariable var_temp2 = body.getOrCreateVariableByName("temp2");
      	PVariable var_type = body.getOrCreateVariableByName("type");
      	PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      	PVariable var_packageableElement = body.getOrCreateVariableByName("packageableElement");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_self, "self"),
      				
      		new ExportedParameter(body, var_temp2, "temp2")
      	));
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      	new TypeConstraint(body, new FlatTuple(var_temp2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Type")));
      	new TypeConstraint(body, new FlatTuple(var_type), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Type")));
      	new Equality(body, var_temp1, var_type);
      	new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      	new TypeConstraint(body, new FlatTuple(var_self, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package", "packagedElement")));
      	new Equality(body, var__virtual_0_, var_packageableElement);
      	new Equality(body, var_temp1, var_packageableElement);
      	new Equality(body, var_temp2, var_temp1);
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "ownedType");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
