package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.PackageOwnedStereotypeMatch;
import org.eclipse.incquery.uml.derivedfeatures.PackageOwnedStereotypeMatcher;

/**
 * A pattern-specific query specification that can instantiate PackageOwnedStereotypeMatcher in a type-safe way.
 * 
 * @see PackageOwnedStereotypeMatcher
 * @see PackageOwnedStereotypeMatch
 * 
 */
@SuppressWarnings("all")
public final class PackageOwnedStereotypeQuerySpecification extends BaseGeneratedEMFQuerySpecification<PackageOwnedStereotypeMatcher> {
  private PackageOwnedStereotypeQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static PackageOwnedStereotypeQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected PackageOwnedStereotypeMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return PackageOwnedStereotypeMatcher.on(engine);
  }
  
  @Override
  public PackageOwnedStereotypeMatch newEmptyMatch() {
    return PackageOwnedStereotypeMatch.newEmptyMatch();
  }
  
  @Override
  public PackageOwnedStereotypeMatch newMatch(final Object... parameters) {
    return PackageOwnedStereotypeMatch.newMatch((org.eclipse.uml2.uml.Package) parameters[0], (org.eclipse.uml2.uml.Stereotype) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static PackageOwnedStereotypeQuerySpecification INSTANCE = make();
    
    public static PackageOwnedStereotypeQuerySpecification make() {
      return new PackageOwnedStereotypeQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static PackageOwnedStereotypeQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.packageOwnedStereotype";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("self","temp2");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("self", "org.eclipse.uml2.uml.Package"),new PParameter("temp2", "org.eclipse.uml2.uml.Stereotype"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      	{
      		PBody body = new PBody(this);
      		PVariable var_self = body.getOrCreateVariableByName("self");
      		PVariable var_temp2 = body.getOrCreateVariableByName("temp2");
      		PVariable var_stereotype = body.getOrCreateVariableByName("stereotype");
      		PVariable var_temp1 = body.getOrCreateVariableByName("temp1");
      		PVariable var_packageableElement = body.getOrCreateVariableByName("packageableElement");
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      		new TypeConstraint(body, new FlatTuple(var_temp2), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Stereotype")));
      		body.setSymbolicParameters(Arrays.<ExportedParameter>asList(
      		   new ExportedParameter(body, var_self, "self"),
      		   new ExportedParameter(body, var_temp2, "temp2")
      		));
      		//     Stereotype(stereotype)
      		new TypeConstraint(body, new FlatTuple(var_stereotype), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Stereotype")));
      		//     temp1 == stereotype
      		new Equality(body, var_temp1, var_stereotype);
      		//     Package.packagedElement(self, packageableElement)
      		new TypeConstraint(body, new FlatTuple(var_self), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package")));
      		PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      		new TypeConstraint(body, new FlatTuple(var_self, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Package", "packagedElement")));
      		new Equality(body, var__virtual_0_, var_packageableElement);
      		//     temp1 == packageableElement
      		new Equality(body, var_temp1, var_packageableElement);
      		//     temp2 == temp1
      		new Equality(body, var_temp2, var_temp1);
      		bodies.add(body);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("Surrogate");
      		annotation.addAttribute("feature", "ownedStereotype");
      		addAnnotation(annotation);
      	}
      	                {
      		PAnnotation annotation = new PAnnotation("QueryExplorer");
      		annotation.addAttribute("checked", false);
      		addAnnotation(annotation);
      	}
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
