/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;

public class EdgeDelayer {
    private Multimap<Item, Edge> delayedEdgesForNonExistingSource = HashMultimap.create();
    private Multimap<Item, Edge> delayedEdgesForNonExistingTarget = HashMultimap.create();

    protected void delayEdgeForNonExistingSource(Edge edge) {
        this.delayedEdgesForNonExistingSource.put((Object)edge.getSource(), (Object)edge);
    }

    protected void delayEdgeForNonExistingTarget(Edge edge) {
        this.delayedEdgesForNonExistingTarget.put((Object)edge.getTarget(), (Object)edge);
    }

    protected boolean removeDelayedEdgeForNonExistingSource(Edge edge) {
        return this.delayedEdgesForNonExistingSource.remove((Object)edge.getSource(), (Object)edge);
    }

    protected boolean removeDelayedEdgeForNonExistingTarget(Edge edge) {
        return this.delayedEdgesForNonExistingTarget.remove((Object)edge.getTarget(), (Object)edge);
    }

    protected Collection<Edge> removeDelayedEdgesForItem(Item item) {
        Collection delayedEdgesForSource = this.delayedEdgesForNonExistingSource.removeAll((Object)item);
        Collection delayedEdgesForTarget = this.delayedEdgesForNonExistingTarget.removeAll((Object)item);
        ImmutableSet allEdges = ImmutableSet.builder().addAll((Iterable)delayedEdgesForSource).addAll((Iterable)delayedEdgesForTarget).build();
        return allEdges;
    }
}

