/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.basic;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Book;
import ee.jakarta.tck.nosql.factories.BookSupplier;
import java.time.Duration;
import java.util.Optional;
import java.util.logging.Logger;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The basic template operations with Record as entity")
public class BasicTemplateRecordTest
extends AbstractTemplateTest {
    private static final Logger LOGGER = Logger.getLogger(BasicTemplateRecordTest.class.getName());

    @ParameterizedTest
    @ArgumentsSource(value=BookSupplier.class)
    @DisplayName(value="Should insert the book: {0}")
    void shouldInsert(Book entity) {
        Book book = (Book)this.template.insert((Object)entity);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)book).isNotNull();
            soft.assertThat(book.id()).isNotNull();
            soft.assertThat(book.title()).isEqualTo(entity.title());
            soft.assertThat(book.author()).isEqualTo(entity.author());
            soft.assertThat(book.publisher()).isEqualTo(entity.publisher());
            soft.assertThat(book.genre()).isEqualTo(entity.genre());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=BookSupplier.class)
    @DisplayName(value="Should update the book: {0}")
    void shouldUpdate(Book entity) {
        Book insertedBook = (Book)this.template.insert((Object)entity);
        Book updatedBook = (Book)this.template.update((Object)insertedBook);
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat((Object)updatedBook).isNotNull();
            soft.assertThat(updatedBook.id()).isEqualTo(insertedBook.id());
            soft.assertThat(updatedBook.title()).isEqualTo(insertedBook.title());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=BookSupplier.class)
    @DisplayName(value="Should delete the book: {0}")
    void shouldDelete(Book entity) {
        Book insertedBook = (Book)this.template.insert((Object)entity);
        this.template.delete(Book.class, (Object)insertedBook.id());
        Optional deletedBook = this.template.find(Book.class, (Object)insertedBook.id());
        SoftAssertions.assertSoftly(soft -> soft.assertThat(deletedBook).isEmpty());
    }

    @ParameterizedTest
    @ArgumentsSource(value=BookSupplier.class)
    @DisplayName(value="Should find the book: {0}")
    void shouldFind(Book entity) {
        Book insertedBook = (Book)this.template.insert((Object)entity);
        Optional foundBook = this.template.find(Book.class, (Object)insertedBook.id());
        SoftAssertions.assertSoftly(soft -> {
            soft.assertThat(foundBook).isPresent();
            soft.assertThat(((Book)foundBook.orElseThrow()).id()).isEqualTo(insertedBook.id());
            soft.assertThat(((Book)foundBook.orElseThrow()).title()).isEqualTo(insertedBook.title());
        });
    }

    @ParameterizedTest
    @ArgumentsSource(value=BookSupplier.class)
    @DisplayName(value="Should insert book with TTL")
    void shouldInsertWithTTL(Book book) {
        try {
            Book insertedBook = (Book)this.template.insert((Object)book, Duration.ofMinutes(10L));
            SoftAssertions.assertSoftly(soft -> {
                soft.assertThat((Object)insertedBook).isNotNull();
                soft.assertThat(insertedBook.id()).isNotNull();
                soft.assertThat(insertedBook.title()).isEqualTo(book.title());
            });
        }
        catch (UnsupportedOperationException e) {
            LOGGER.info("TTL operation not supported by this database: " + e.getMessage());
        }
    }

    @Test
    @DisplayName(value="Should throw exception when null entity is inserted")
    void shouldThrowExceptionWhenNullEntityInserted() {
        Assertions.assertThatThrownBy(() -> this.template.insert(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    @DisplayName(value="Should throw exception when null entity is updated")
    void shouldThrowExceptionWhenNullEntityUpdated() {
        Assertions.assertThatThrownBy(() -> this.template.update(null)).isInstanceOf(NullPointerException.class);
    }
}

