/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.generator;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.types.generator.Client;
import ee.jakarta.tck.persistence.core.types.generator.DataTypes4;
import java.util.Properties;

public class Client4
extends Client {
    private DataTypes4 d12;
    private boolean supports_sequence = false;

    public static void main(String[] args) {
        Client4 theTests = new Client4();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        block4: {
            this.logTrace("setup");
            try {
                super.setup(args, p);
                String s = p.getProperty("db.supports.sequence");
                if (s != null) {
                    this.supports_sequence = Boolean.parseBoolean(s);
                    this.logMsg("db.supports.sequence:" + this.supports_sequence);
                    if (this.supports_sequence) {
                        this.removeTestData();
                        this.createDataTypes4Data();
                    }
                    break block4;
                }
                this.logErr("The property db.supports.sequence is not defined in the ts.jte, this must be corrected before running tests");
                throw new Exception("setupDataTypes4 failed");
            }
            catch (Exception e) {
                this.logErr("Exception: ", e);
                throw new Exception("setupDataTypes4 failed:", e);
            }
        }
    }

    public void sequenceGeneratorOnPropertyTest() throws Exception {
        boolean pass;
        block10: {
            pass = true;
            if (this.supports_sequence) {
                Integer newInt = 1000;
                try {
                    this.getEntityTransaction().begin();
                    this.clearCache();
                    this.logMsg("Doing a find of id: " + this.d12.getId());
                    DataTypes4 d = (DataTypes4)this.getEntityManager().find(DataTypes4.class, (Object)this.d12.getId());
                    if (d != null) {
                        Integer i = d.getIntegerData();
                        if (i.equals(this.d12.getIntegerData())) {
                            this.logTrace("find returned correct Integer value:" + i);
                            d.setIntegerData(newInt);
                        } else {
                            this.logErr("find did not return correct Integer value, expected: " + this.d12.getIntegerData() + ", actual:" + i);
                            pass = false;
                        }
                        this.getEntityManager().merge((Object)d);
                        this.getEntityManager().flush();
                        this.clearCache();
                        this.logMsg("Doing a find of merged data for id: " + d.getId());
                        DataTypes4 d2 = (DataTypes4)this.getEntityManager().find(DataTypes4.class, (Object)d.getId());
                        i = d2.getIntegerData();
                        if (i.equals(d2.getIntegerData())) {
                            this.logTrace("find returned correct merged Integer value:" + i);
                        } else {
                            this.logErr("find did not return correct Integer value, expected: " + d.getIntegerData() + ", actual:" + i);
                            pass = false;
                        }
                        this.getEntityTransaction().commit();
                        break block10;
                    }
                    this.logErr("find returned null result");
                    pass = false;
                }
                catch (Exception e) {
                    this.logErr("Unexpected exception occurred", e);
                    pass = false;
                }
            } else {
                this.logMsg("WARNING: Test not run because db.supports.sequence set to false in ts.jte");
            }
        }
        if (!pass) {
            throw new Exception("sequenceGeneratorOnEntityTest failed");
        }
    }

    public void createDataTypes4Data() {
        try {
            this.getEntityTransaction().begin();
            this.logTrace("in createDataTypes4Data");
            this.logTrace("new DataType4");
            this.d12 = new DataTypes4(500);
            this.logTrace("Persist DataType4");
            this.getEntityManager().persist((Object)this.d12);
            this.logTrace("DataType4 id:" + this.d12.getId());
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
    }
}

