/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.internal;

import java.util.Map;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.analyze.internal.Analyze;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.internal.Renderer;
import org.eclipse.jubula.client.analyze.internal.helper.RendererSelectionHelper;
import org.eclipse.jubula.client.analyze.ui.definition.IResultRendererUI;
import org.eclipse.jubula.client.analyze.ui.internal.QueryResult;
import org.eclipse.jubula.client.analyze.ui.internal.listener.AnalyzeTreeViewerDoubleClickListener;
import org.eclipse.jubula.client.analyze.ui.internal.provider.QueryTreeContentProvider;
import org.eclipse.jubula.client.analyze.ui.internal.provider.QueryTreeLabelProvider;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.Page;

public class ResultPage
extends Page
implements ISearchResultPage {
    private Control m_control;
    private String m_id;
    private QueryResult m_queryResult;
    private TreeViewer m_tvl;
    private Composite m_stackComp;
    private Composite m_parentComp;
    private AnalyzeTreeViewerDoubleClickListener m_listener;

    public TreeViewer getLeftTreeViewer() {
        return this.m_tvl;
    }

    public Composite getStackComposite() {
        return this.m_stackComp;
    }

    public AnalyzeTreeViewerDoubleClickListener getListener() {
        return this.m_listener;
    }

    public void setListener(AnalyzeTreeViewerDoubleClickListener listener) {
        this.m_listener = listener;
    }

    public QueryResult getQueryResult() {
        return this.m_queryResult;
    }

    public void setQueryResult(QueryResult queryResult) {
        this.m_queryResult = queryResult;
    }

    private void setParentComposite(Composite parent) {
        this.m_parentComp = parent;
    }

    private Composite getParentComposite() {
        return this.m_parentComp;
    }

    public void setStackComposite(Composite comp) {
        this.m_stackComp = comp;
    }

    public void createControl(Composite parent) {
        this.setQueryResult(null);
        this.setParentComposite(null);
        Composite par = new Composite(parent, 0);
        FillLayout f = new FillLayout(256);
        par.setLayout((Layout)f);
        Composite c = new Composite(par, 0);
        StackLayout s = new StackLayout();
        c.setLayout((Layout)s);
        this.setParentComposite(c);
        this.setControl((Control)par);
    }

    public void dispose() {
    }

    private void setControl(Control control) {
        this.m_control = control;
    }

    public Control getControl() {
        return this.m_control;
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public Object getUIState() {
        return null;
    }

    public void setInput(ISearchResult search, Object uiState) {
        if (search instanceof QueryResult) {
            this.setQueryResult((QueryResult)search);
            if (this.getQueryResult().getResultMap().size() == 1) {
                Analyze analyze = null;
                AnalyzeResult result = null;
                for (Map.Entry<Analyze, AnalyzeResult> a : this.getQueryResult().getResultMap().entrySet()) {
                    analyze = a.getKey();
                    result = a.getValue();
                }
                if (analyze != null && result != null) {
                    Renderer ren = RendererSelectionHelper.getActiveRenderer(analyze);
                    IResultRendererUI rendererUI = (IResultRendererUI)ren.getRendererInstance();
                    rendererUI.renderResult(result, this.getParentComposite());
                    if (this.getParentComposite().getLayout() instanceof StackLayout) {
                        StackLayout sl = (StackLayout)this.getParentComposite().getLayout();
                        sl.topControl = rendererUI.getTopControl();
                        this.getParentComposite().layout();
                    }
                    this.getParentComposite().layout();
                }
            }
            if (this.getQueryResult().getResultMap().size() > 1) {
                SashForm sash = new SashForm(this.getParentComposite(), 256);
                this.m_tvl = new TreeViewer((Composite)sash);
                this.m_tvl.setContentProvider((IContentProvider)new QueryTreeContentProvider());
                this.m_tvl.setLabelProvider((IBaseLabelProvider)new QueryTreeLabelProvider());
                StackLayout stack = new StackLayout();
                Composite cmp = new Composite((Composite)sash, 0);
                cmp.setLayout((Layout)stack);
                this.setStackComposite(cmp);
                this.m_listener = new AnalyzeTreeViewerDoubleClickListener(cmp);
                this.m_tvl.addDoubleClickListener((IDoubleClickListener)this.m_listener);
                sash.setWeights(new int[]{40, 60});
                TreeViewer tv = new TreeViewer(this.getStackComposite());
                StackLayout l = (StackLayout)this.getStackComposite().getLayout();
                l.topControl = tv.getControl();
                this.getStackComposite().layout();
                this.getLeftTreeViewer().setInput((Object)search);
                this.getLeftTreeViewer().expandAll();
                TreePath[] paths = this.getLeftTreeViewer().getExpandedTreePaths();
                if (paths.length > 0) {
                    TreeSelection sel = new TreeSelection(paths);
                    this.getLeftTreeViewer().setSelection((ISelection)sel, true);
                }
                StackLayout s = (StackLayout)this.getParentComposite().getLayout();
                s.topControl = sash;
                this.getParentComposite().layout();
            }
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.m_id = id;
    }

    public String getID() {
        return this.m_id;
    }

    public String getLabel() {
        return "";
    }
}

