/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.internal.helper;

import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.analyze.ExtensionRegistry;
import org.eclipse.jubula.client.analyze.definition.IContext;
import org.eclipse.jubula.client.analyze.internal.Analyze;
import org.eclipse.jubula.client.analyze.internal.Context;
import org.eclipse.jubula.client.analyze.internal.helper.ProjectContextHelper;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;

public class ContextHelper {
    private static Object selection;

    private ContextHelper() {
    }

    public static boolean isEnabled(Analyze analyze) {
        ProjectContextHelper.setObjContType((String)"");
        String[] contextData = ContextHelper.contextDataToArray(analyze.getContextType());
        for (Map.Entry c : ExtensionRegistry.getContexts().entrySet()) {
            Context context = (Context)c.getValue();
            int i = 0;
            while (i < contextData.length) {
                if (contextData[i].equals(context.getID()) && !context.getID().equals("projectloaded")) {
                    IContext iCon = (IContext)context.getContextInstance();
                    ISelectionService serv = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService();
                    ISelection sel = serv.getSelection();
                    if (sel instanceof IStructuredSelection) {
                        IStructuredSelection structuredSel = (IStructuredSelection)sel;
                        if (structuredSel.getFirstElement() instanceof IExecObjContPO) {
                            ContextHelper.setSelection(GeneralStorage.getInstance().getProject());
                            ProjectContextHelper.setObjContType((String)"IExecObjContPO");
                        } else if (structuredSel.getFirstElement() instanceof ISpecObjContPO) {
                            ContextHelper.setSelection(GeneralStorage.getInstance().getProject());
                            ProjectContextHelper.setObjContType((String)"ISpecObjContPO");
                        } else {
                            ContextHelper.setSelection(structuredSel.getFirstElement());
                        }
                        if (iCon.isActive(ContextHelper.getSelection())) {
                            return true;
                        }
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isEnabledProject(Analyze analyze) {
        String[] contextData = ContextHelper.contextDataToArray(analyze.getContextType());
        for (Map.Entry c : ExtensionRegistry.getContexts().entrySet()) {
            Context context = (Context)c.getValue();
            IContext iCon = (IContext)context.getContextInstance();
            int i = 0;
            while (i < contextData.length) {
                if (contextData[i].equals("projectloaded") && context.getID().equals("projectloaded") && GeneralStorage.getInstance().getProject() != null) {
                    ProjectContextHelper.setObjContType((String)"project");
                    ContextHelper.setSelection(GeneralStorage.getInstance().getProject());
                    if (iCon.isActive(ContextHelper.getSelection())) {
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] contextDataToArray(String context) {
        Pattern p = Pattern.compile(",");
        String[] contextData = p.split(context, 0);
        int i = 0;
        while (i < contextData.length) {
            contextData[i] = contextData[i].trim().toLowerCase();
            ++i;
        }
        return contextData;
    }

    public static Object getSelection() {
        return selection;
    }

    public static void setSelection(Object sel) {
        selection = sel;
    }
}

