/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.ui.renderer;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.ui.definition.IResultRendererUI;
import org.eclipse.jubula.client.analyze.ui.i18n.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRenderer
implements IResultRendererUI {
    private AnalyzeResult m_analyzeResult;
    private Control m_topControl;

    @Override
    public Control getTopControl() {
        return this.m_topControl;
    }

    public void setTopControl(Control control) {
        this.m_topControl = control;
    }

    @Override
    public void renderResult(AnalyzeResult res, Composite composite) {
        this.m_analyzeResult = res;
        if (this.m_analyzeResult.getResult() instanceof Map) {
            Map resultMap = (Map)this.m_analyzeResult.getResult();
            ArrayList<TableResult> resultList = new ArrayList<TableResult>();
            for (Map.Entry e : resultMap.entrySet()) {
                TableResult tr = new TableResult();
                if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.TestSuitePO")) {
                    tr.setCol1(Messages.Testsuite);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.CategoryPO")) {
                    tr.setCol1(Messages.Category);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.CapPO")) {
                    tr.setCol1(Messages.TestStep);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.ExecTestCasePO")) {
                    tr.setCol1(Messages.ReferencedTestCase);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.ProjectPO")) {
                    tr.setCol1(Messages.Project);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.SpecTestCasePO")) {
                    tr.setCol1(Messages.Testcase);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.TestJobPO")) {
                    tr.setCol1(Messages.TestJob);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.RefTestSuitePO")) {
                    tr.setCol1(Messages.ReferencedTestSuite);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.ComponentNamePO")) {
                    tr.setCol1(Messages.ComponentName);
                } else if (String.valueOf(e.getKey()).equals("class org.eclipse.jubula.client.core.model.EventExecTestCasePO")) {
                    tr.setCol1(Messages.EventHandler);
                }
                tr.setCol2(String.valueOf(e.getValue()));
                resultList.add(tr);
            }
            this.createViewer(composite, resultList);
        }
    }

    private void createViewer(Composite parent, List<TableResult> resultList) {
        TableViewer tv = new TableViewer(parent);
        this.createColumns(parent, tv);
        Table table = tv.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        tv.setContentProvider((IContentProvider)new ArrayContentProvider());
        tv.setSorter((ViewerSorter)new TableResultSorter());
        tv.setInput(resultList);
        this.setTopControl(tv.getControl());
    }

    private void createColumns(Composite cmp, TableViewer viewer) {
        String[] titles = new String[]{Messages.NodeType, Messages.Amount};
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] colType = nArray;
        int c1 = cmp.getBounds().width / 3 * 2;
        int c2 = cmp.getBounds().width / 3;
        int[] bounds = new int[]{c1, c2};
        TableViewerColumn col = this.createTabelViewerColumn(titles[0], bounds[0], viewer, colType[0]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableResult tr = (TableResult)element;
                return tr.getCol1();
            }
        });
        col = this.createTabelViewerColumn(titles[1], bounds[1], viewer, colType[1]);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                TableResult tr = (TableResult)element;
                return tr.getCol2();
            }
        });
    }

    private TableViewerColumn createTabelViewerColumn(String title, int bounds, TableViewer viewer, int colType) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        final int c = colType;
        TableColumn column = viewerColumn.getColumn();
        final TableViewer tv = viewer;
        column.setText(title);
        column.setWidth(bounds);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ((TableResultSorter)tv.getSorter()).doSort(c);
                tv.refresh();
            }
        });
        return viewerColumn;
    }

    public class TableResult {
        private String m_col1;
        private String m_col2;

        public String getCol1() {
            return this.m_col1;
        }

        public void setCol1(String col1) {
            this.m_col1 = col1;
        }

        public String getCol2() {
            return this.m_col2;
        }

        public void setCol2(String col2) {
            this.m_col2 = col2;
        }
    }

    class TableResultSorter
    extends ViewerSorter {
        private static final int ASCENDING = 0;
        private static final int DESCENDING = 1;
        private int m_column;
        private int m_direction;

        TableResultSorter() {
        }

        public void doSort(int column) {
            if (column == this.m_column) {
                this.m_direction = 1 - this.m_direction;
            } else {
                this.m_column = column;
                this.m_direction = 0;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            int rc = 0;
            TableResult tr1 = (TableResult)e1;
            TableResult tr2 = (TableResult)e2;
            Collator col = Collator.getInstance();
            switch (this.m_column) {
                case 0: {
                    rc = col.compare(tr1.getCol1(), tr2.getCol1());
                    break;
                }
                case 1: {
                    if (new Integer(tr1.getCol2()) < new Integer(tr2.getCol2())) {
                        rc = -1;
                        break;
                    }
                    if (new Integer(tr1.getCol2()) == new Integer(tr2.getCol2())) {
                        rc = 0;
                        break;
                    }
                    if (new Integer(tr1.getCol2()) <= new Integer(tr2.getCol2())) break;
                    rc = 1;
                    break;
                }
            }
            if (this.m_direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }
}

