/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.actions;

import java.io.File;
import org.eclipse.jface.action.IAction;
import org.eclipse.jubula.client.ui.rcp.actions.AbstractAction;
import org.eclipse.jubula.client.ui.rcp.businessprocess.AbstractActionBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.ShowClientLogBP;
import org.eclipse.jubula.client.ui.rcp.editors.ClientLogInput;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ShowClientLogAction
extends AbstractAction {
    private IEditorInput m_clientLogInput = null;

    public void runWithEvent(IAction action, Event event) {
        if (action != null && !action.isEnabled()) {
            return;
        }
        File clientLogFile = ShowClientLogBP.getInstance().getClientLogFile();
        if (clientLogFile != null && clientLogFile.canRead()) {
            IWorkbenchPage currentPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (currentPage != null) {
                if (this.m_clientLogInput != null && currentPage.findEditor(this.m_clientLogInput) != null) {
                    currentPage.closeEditor(currentPage.findEditor(this.m_clientLogInput), false);
                }
                this.m_clientLogInput = new ClientLogInput(clientLogFile);
                try {
                    currentPage.openEditor(this.m_clientLogInput, "org.eclipse.jubula.client.ui.rcp.editors.LogViewer");
                }
                catch (PartInitException partInitException) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_CANNOT_OPEN_EDITOR);
                }
            }
        } else {
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.I_NO_CLIENT_LOG_FOUND);
        }
    }

    protected AbstractActionBP getActionBP() {
        return ShowClientLogBP.getInstance();
    }
}

