/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.propertysources;

import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBP;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.TestCaseParamBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.IVerifiable;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractPropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.IParameterPropertyController;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.tools.xml.businessmodell.Param;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGuiNodePropertySource
extends AbstractPropertySource<INodePO> {
    public static final String P_ELEMENT_DISPLAY_COMMENT = Messages.AbstractGuiNodePropertySourceComment;
    private TestCaseParamBP m_testCaseParamBP;
    private boolean m_readOnly;
    private IParameterPropertyController.ParameterInputType m_activeParameterInputType = IParameterPropertyController.ParameterInputType.LOCAL;
    private IPropertyDescriptor m_commentDesc = null;

    public AbstractGuiNodePropertySource(INodePO guiNode) {
        super(guiNode);
        this.m_testCaseParamBP = new TestCaseParamBP();
    }

    protected void initPropDescriptor() {
        if (this.m_commentDesc == null) {
            this.m_commentDesc = new TextPropertyDescriptor((Object)new CommentController(), P_ELEMENT_DISPLAY_COMMENT);
        }
        this.addPropertyDescriptor(this.m_commentDesc);
    }

    protected TestCaseParamBP getTestCaseParamBP() {
        return this.m_testCaseParamBP;
    }

    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    protected void setReadOnly(boolean readOnly) {
        this.m_readOnly = readOnly;
    }

    public void setActiveParameterInputType(IParameterPropertyController.ParameterInputType inputType) {
        this.m_activeParameterInputType = inputType;
    }

    public boolean isParameterEntryEnabled(IParameterPropertyController parameterPropertyController) {
        return parameterPropertyController.getInputType().isEnabled(this.m_activeParameterInputType);
    }

    protected INodePO getPoNode() {
        return (INodePO)this.getGuiNode();
    }

    protected IParamNameMapper getActiveParamNameMapper() {
        ParamNameBPDecorator editorMapper;
        IEditorPart activeEditor = Plugin.getActiveEditor();
        ParamNameBP mapper = ParamNameBP.getInstance();
        if (activeEditor instanceof IJBEditor && (editorMapper = ((IJBEditor)activeEditor).getEditorHelper().getEditSupport().getParamMapper()) != null) {
            mapper = editorMapper;
        }
        return mapper;
    }

    protected IWritableComponentNameMapper getActiveComponentNameMapper() {
        IEditorPart activeEditor = Plugin.getActiveEditor();
        IWritableComponentNameMapper mapper = null;
        if (activeEditor instanceof IJBEditor) {
            mapper = ((IJBEditor)activeEditor).getEditorHelper().getEditSupport().getCompMapper();
        }
        return mapper;
    }

    protected IParamValueValidator getValidatorForConverter(IParamDescriptionPO desc) {
        List pdList = this.getPropertyDescriptorList();
        IVerifiable descr = null;
        for (IPropertyDescriptor pd : pdList) {
            AbstractParamValueController ctrl;
            if (!(pd.getId() instanceof AbstractParamValueController) || !(ctrl = (AbstractParamValueController)pd.getId()).getParamDesc().equals(desc)) continue;
            descr = (IVerifiable)pd;
        }
        return descr != null ? descr.getDataValidator() : new NullValidator();
    }

    public boolean isPropertySet(Object id) {
        if (id instanceof IParameterPropertyController) {
            return ((IParameterPropertyController)id).isPropertySet();
        }
        return false;
    }

    public void updateParameterInputType() {
        this.setActiveParameterInputType(this.calculateActiveParameterInputType());
    }

    private IParameterPropertyController.ParameterInputType calculateActiveParameterInputType() {
        IPropertyDescriptor[] iPropertyDescriptorArray = this.getPropertyDescriptors();
        int n = iPropertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IParameterPropertyController controller;
            IPropertyDescriptor desc = iPropertyDescriptorArray[n2];
            if (desc.getId() instanceof IParameterPropertyController && (controller = (IParameterPropertyController)desc.getId()).isPropertySet()) {
                return controller.getInputType();
            }
            ++n2;
        }
        return IParameterPropertyController.ParameterInputType.LOCAL;
    }

    protected String getParameterNameDescr(IParamDescriptionPO desc) {
        StringBuilder sb = new StringBuilder(desc.getName());
        sb.append(" ");
        sb.append("[");
        sb.append((String)StringHelper.getInstance().getMap().get(desc.getType()));
        sb.append("]");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class AbstractParamValueController
    extends AbstractPropertySource.AbstractPropertyController
    implements IParameterPropertyController {
        private IParamDescriptionPO m_paramDescr;
        private IParamNameMapper m_paramNameMapper;

        public AbstractParamValueController(AbstractGuiNodePropertySource s, IParamDescriptionPO paramDescr, IParamNameMapper paramNameMapper) {
            super(s);
            this.m_paramDescr = paramDescr;
            this.m_paramNameMapper = paramNameMapper;
        }

        protected Iterator getValueSetIterator() {
            INodePO node = AbstractGuiNodePropertySource.this.getPoNode();
            if (!Persistor.isPoSubclass((IPersistentObject)node, ICapPO.class)) {
                return IteratorUtils.EMPTY_ITERATOR;
            }
            Param param = ((ICapPO)node).getMetaAction().findParam(this.m_paramDescr.getUniqueId());
            return param.valueSetIterator();
        }

        public String getProperty() {
            IParamNodePO paramNode = (IParamNodePO)AbstractGuiNodePropertySource.this.getPoNode();
            String property = AbstractParamInterfaceBP.getGuiStringForParamValue((IParameterInterfacePO)paramNode, (IParamDescriptionPO)this.m_paramDescr, (int)0, (Locale)WorkingLanguageBP.getInstance().getWorkingLanguage());
            return property == null ? "" : property;
        }

        public final boolean setProperty(Object value) {
            if (this.getPropertySource().isReadOnly()) {
                return true;
            }
            boolean propSet = false;
            if (value instanceof String) {
                Locale lang;
                IParamNodePO node = (IParamNodePO)AbstractGuiNodePropertySource.this.getPoNode();
                GuiParamValueConverter conv = new GuiParamValueConverter((String)value, (IParameterInterfacePO)node, lang = WorkingLanguageBP.getInstance().getWorkingLanguage(), this.getParamDesc(), AbstractGuiNodePropertySource.this.getValidatorForConverter(this.getParamDesc()));
                if (conv.getErrors().isEmpty()) {
                    AbstractGuiNodePropertySource.this.getTestCaseParamBP().startParameterUpdate(conv, lang, 0, this.m_paramNameMapper);
                    DataEventDispatcher.getInstance().firePropertyChanged(false);
                }
                AbstractGuiNodePropertySource.this.checkEntrySets(node);
                propSet = true;
                return propSet;
            }
            Object val = ((List)value).get(0);
            IParamNodePO node = (IParamNodePO)AbstractGuiNodePropertySource.this.getPoNode();
            IParamNameMapper mapper = (IParamNameMapper)((List)value).get(1);
            Locale lang = WorkingLanguageBP.getInstance().getWorkingLanguage();
            GuiParamValueConverter conv = new GuiParamValueConverter((String)val, (IParameterInterfacePO)node, lang, this.getParamDesc(), AbstractGuiNodePropertySource.this.getValidatorForConverter(this.getParamDesc()));
            if (conv.getErrors().isEmpty()) {
                AbstractGuiNodePropertySource.this.getTestCaseParamBP().startParameterUpdate(conv, lang, 0, mapper);
                DataEventDispatcher.getInstance().firePropertyChanged(false);
            }
            AbstractGuiNodePropertySource.this.checkEntrySets(node);
            propSet = true;
            return propSet;
        }

        public IParamDescriptionPO getParamDesc() {
            return this.m_paramDescr;
        }

        public IParamNodePO getParamNode() {
            return (IParamNodePO)AbstractGuiNodePropertySource.this.getPoNode();
        }

        @Override
        public boolean isPropertySet() {
            return StringUtils.isNotEmpty((String)this.getProperty());
        }

        @Override
        public IParameterPropertyController.ParameterInputType getInputType() {
            return IParameterPropertyController.ParameterInputType.LOCAL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class CommentController
    extends AbstractPropertySource.AbstractPropertyController {
        protected CommentController() {
        }

        public boolean setProperty(Object value) {
            if (value != null) {
                AbstractGuiNodePropertySource.this.getPoNode().setComment(String.valueOf(value));
            } else {
                AbstractGuiNodePropertySource.this.getPoNode().setComment(null);
            }
            return true;
        }

        public Object getProperty() {
            if (AbstractGuiNodePropertySource.this.getPoNode() != null && AbstractGuiNodePropertySource.this.getPoNode().getComment() != null) {
                return AbstractGuiNodePropertySource.this.getPoNode().getComment();
            }
            return "";
        }

        @Override
        public Image getImage() {
            return DEFAULT_IMAGE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ElementNameController
    extends AbstractPropertySource.AbstractPropertyController {
        public boolean setProperty(Object value) {
            String name = null;
            if (value != null) {
                name = String.valueOf(value);
            }
            AbstractGuiNodePropertySource.this.getPoNode().setName(name);
            DataEventDispatcher.getInstance().firePropertyChanged(false);
            return true;
        }

        public Object getProperty() {
            String name;
            if (AbstractGuiNodePropertySource.this.getPoNode() != null && (name = AbstractGuiNodePropertySource.this.getPoNode().getName()) != null) {
                return name;
            }
            return "";
        }
    }
}

