/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputDialog
extends TitleAreaDialog {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_4 = 4;
    private static final int VERTICAL_SPACING = 2;
    private static final int MARGIN_WIDTH = 10;
    private static final int MARGIN_HEIGHT = 10;
    private static final int WIDTH_HINT = 300;
    private static final int HORIZONTAL_SPAN = 3;
    private String m_name = "";
    private Text m_nameField;
    private String m_message = "";
    private String m_wrongNameError = "";
    private String m_doubleNameError = "";
    private String m_label = "";
    private String m_image = "";
    private String m_shell = "";
    private String m_title = "";
    private String m_oldName = "";
    private boolean m_browseable;
    private int m_length = 255;
    private Button m_button;

    public InputDialog(Shell parentShell, String title, String oldName, String message, String label, String wrongNameError, String doubleNameError, String image, String shell, boolean browseable) {
        this(parentShell, title, oldName, message, label, wrongNameError, doubleNameError, image, shell, browseable, 255);
    }

    public InputDialog(Shell parentShell, String title, String oldName, String message, String label, String wrongNameError, String doubleNameError, String image, String shell, boolean browseable, int maxLength) {
        super(parentShell);
        this.m_browseable = browseable;
        this.m_oldName = oldName;
        this.m_message = message;
        this.m_label = label;
        this.m_wrongNameError = wrongNameError;
        this.m_doubleNameError = doubleNameError;
        this.m_image = image;
        this.m_shell = shell;
        this.m_title = title;
        this.m_length = maxLength;
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(this.m_message);
        this.setTitle(this.m_title);
        this.setTitleImage(Plugin.getImage(this.m_image));
        this.getShell().setText(this.m_shell);
        GridLayout gridLayoutParent = new GridLayout();
        gridLayoutParent.numColumns = 1;
        gridLayoutParent.verticalSpacing = 2;
        gridLayoutParent.marginWidth = 10;
        gridLayoutParent.marginHeight = 10;
        parent.setLayout((Layout)gridLayoutParent);
        LayoutUtil.createSeparator((Composite)parent);
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        area.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 300;
        area.setLayoutData((Object)gridData);
        this.createNameField(area);
        this.createAdditionalComponents(area);
        LayoutUtil.createSeparator((Composite)parent);
        return area;
    }

    public void setStyle(int style) {
        this.setShellStyle(style);
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.modifyNameFieldAction();
        this.setMessage(this.m_message);
    }

    private void createNameField(Composite area) {
        new Label(area, 0).setText(this.m_label);
        this.m_nameField = new Text(area, 2052);
        GridData gridData = this.newGridData(false);
        LayoutUtil.addToolTipAndMaxWidth((GridData)gridData, (Control)this.m_nameField);
        this.m_nameField.setLayoutData((Object)gridData);
        if (this.m_oldName != null) {
            this.m_nameField.setText(this.m_oldName);
        }
        LayoutUtil.setMaxChar((Text)this.m_nameField, (int)this.m_length);
        this.m_nameField.selectAll();
        this.m_nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (InputDialog.this.getButton(0) != null) {
                    InputDialog.this.modifyNameFieldAction();
                }
            }
        });
        if (this.m_browseable) {
            this.m_button = new Button(area, 0);
            this.m_button.setText(Messages.InputDialogBrowse);
            this.m_button.setLayoutData((Object)this.newGridData(true));
            this.m_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InputDialog.this.handleButtonEvent();
                }
            });
        }
    }

    void handleButtonEvent() {
        FileDialog dialog = new FileDialog(Plugin.getShell(), 65536);
        dialog.setFilterPath(Utils.getLastDirPath());
        dialog.setText(Messages.InputDialogSelectJRE);
        String path = dialog.open();
        if (path != null) {
            Utils.storeLastDirPath(dialog.getFilterPath());
            this.m_nameField.setText(path);
        }
    }

    boolean modifyNameFieldAction() {
        boolean isCorrect = true;
        int nameLength = this.m_nameField.getText().length();
        if (nameLength == 0 || this.m_nameField.getText().startsWith(" ") || this.m_nameField.getText().charAt(nameLength - 1) == ' ') {
            isCorrect = false;
        }
        if (isCorrect) {
            this.enableOKButton();
            if (!this.isInputAllowed()) {
                this.getButton(0).setEnabled(false);
                this.setErrorMessage(this.m_doubleNameError);
                isCorrect = false;
            }
        } else {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(this.m_wrongNameError);
        }
        return isCorrect;
    }

    protected boolean isInputAllowed() {
        return true;
    }

    private void enableOKButton() {
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(true);
        }
        this.setErrorMessage(null);
    }

    protected void okPressed() {
        if (!this.modifyNameFieldAction()) {
            return;
        }
        this.m_name = this.m_nameField.getText();
        this.setReturnCode(0);
        this.close();
    }

    private GridData newGridData(boolean isButton) {
        GridData gridData = new GridData();
        if (!this.m_browseable) {
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = 3;
        } else if (!isButton) {
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = 2;
        } else {
            gridData.horizontalAlignment = 4;
            gridData.horizontalSpan = 1;
        }
        return gridData;
    }

    public String getName() {
        return this.m_name;
    }

    public String getInputFieldText() {
        return this.m_nameField.getText();
    }

    protected void setInputFieldText(String text) {
        this.m_nameField.setText(text);
    }

    protected void createAdditionalComponents(Composite parent) {
        parent.setEnabled(true);
    }
}

