/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.editors;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jubula.client.ui.rcp.editors.ISimpleEditorInput;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.ui.IPersistableElement;

public class ClientLogInput
extends PlatformObject
implements ISimpleEditorInput {
    private File m_logFile;

    public ClientLogInput(File logFile) {
        this.m_logFile = logFile;
    }

    public boolean exists() {
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public String getName() {
        return Messages.ClientLogViewerName;
    }

    public String getToolTipText() {
        return this.m_logFile.getAbsolutePath();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getContent() throws CoreException {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.m_logFile));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(String.valueOf(line) + "\n");
            }
            return sb.toString();
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jubula.client.ui.rcp", 0, Messages.ErrorMessageFILE_NOT_FOUND, (Throwable)e));
        }
        catch (IOException ioe) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jubula.client.ui.rcp", 0, Messages.ErrorMessageIO_EXCEPTION, (Throwable)ioe));
        }
    }
}

