/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.DirectComboBoxDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMergeComponentNameHandler
extends AbstractSelectionBasedHandler {
    protected IComponentNamePO openDialog(Set<IComponentNamePO> compNames) {
        DirectComboBoxDialog<IComponentNamePO> dialog = this.createDialog(compNames);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog(dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.mergeComponentNameContextId");
        if (dialog.open() == 0) {
            IComponentNamePO selectedCompNamePo = dialog.getSelection();
            compNames.remove(selectedCompNamePo);
            return selectedCompNamePo;
        }
        return null;
    }

    protected DirectComboBoxDialog<IComponentNamePO> createDialog(Set<IComponentNamePO> compNames) {
        ArrayList<IComponentNamePO> compNamesList = new ArrayList<IComponentNamePO>(compNames);
        Collections.sort(compNamesList, new Comparator<IComponentNamePO>(){

            @Override
            public int compare(IComponentNamePO compName1, IComponentNamePO compName2) {
                return compName1.getName().compareTo(compName2.getName());
            }
        });
        ArrayList<String> displayNameList = new ArrayList<String>();
        for (IComponentNamePO compName : compNamesList) {
            displayNameList.add(compName.getName());
        }
        DirectComboBoxDialog<IComponentNamePO> dialog = new DirectComboBoxDialog<IComponentNamePO>(this.getActiveShell(), compNamesList, displayNameList, Messages.MergeComponentNamesMessage, Messages.MergeComponentNamesShellTitle, IconConstants.MERGE_COMPONENT_NAME_DIALOG_IMAGE, Messages.MergeComponentNamesShellTitle, Messages.MergeComponentNamesLabel);
        return dialog;
    }

    protected void performOperation(Set<IComponentNamePO> compNames, IComponentNamePO selectedCompNamePo) {
        for (IComponentNamePO compName : compNames) {
            compName.setReferencedGuid(selectedCompNamePo.getGuid());
        }
    }

    protected void fireChangeEvents(Set<IComponentNamePO> compNames) {
        for (IComponentNamePO compName : compNames) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)compName, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
        }
    }

    protected Set<IComponentNamePO> getComponentNames(IStructuredSelection structuredSel) {
        HashSet<IComponentNamePO> compNames = new HashSet<IComponentNamePO>();
        Object[] objectArray = structuredSel.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof IComponentNamePO) {
                compNames.add((IComponentNamePO)obj);
            }
            ++n2;
        }
        return compNames;
    }
}

