/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.dialogs.InputDialog;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddNewTestDataCategoryHandler
extends AbstractHandler {
    public Object executeImpl(final ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof CentralTestDataEditor) {
            CentralTestDataEditor ctdEditor = (CentralTestDataEditor)activePart;
            ctdEditor.getEditorHelper().doEditorOperation(new IEditorOperation(){

                public void run(IPersistentObject workingPo) {
                    ITestDataCategoryPO rootCategory = (ITestDataCategoryPO)workingPo;
                    ITestDataCategoryPO categoryParent = AddNewTestDataCategoryHandler.getParent(HandlerUtil.getCurrentSelection((ExecutionEvent)event), rootCategory);
                    InputDialog dialog = new InputDialog(AddNewTestDataCategoryHandler.this.getActiveShell(), Messages.CreateNewCategoryActionCatTitle, "New category", Messages.CreateNewCategoryActionCatMessage, Messages.CreateNewCategoryActionCatLabel, Messages.CreateNewCategoryActionCatError, Messages.CreateNewCategoryActionDoubleCatName, "newCategoryDialog.gif", Messages.CreateNewCategoryActionNewCategory, false);
                    dialog.setHelpAvailable(true);
                    dialog.create();
                    DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
                    Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.newTestDataCategoryContextId");
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        ITestDataCategoryPO category = PoMaker.createTestDataCategoryPO((String)dialog.getName());
                        categoryParent.addCategory(category);
                        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)category, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
                    }
                }
            });
        }
        return null;
    }

    public static ITestDataCategoryPO getParent(ISelection selection, ITestDataCategoryPO fallback) {
        IStructuredSelection structuredSelection;
        Object selectedObject;
        if (selection instanceof IStructuredSelection && (selectedObject = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ITestDataCategoryPO) {
            return (ITestDataCategoryPO)selectedObject;
        }
        return fallback;
    }
}

