/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.NagDialog;
import org.eclipse.jubula.client.ui.rcp.handlers.project.OpenProjectHandler;
import org.eclipse.jubula.client.ui.rcp.widgets.JavaAutConfigComponent;
import org.eclipse.jubula.client.ui.rcp.wizards.ProjectWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class NewProjectHandler
extends AbstractProjectHandler {
    private boolean m_alreadyNagged = false;

    private void openNewProjectWizard() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                final ProjectWizard projectWizard = new ProjectWizard();
                projectWizard.init(null, null);
                WizardDialog dialog = new WizardDialog(NewProjectHandler.this.getActiveShell(), (IWizard)projectWizard){

                    protected void finishPressed() {
                        String selectedToolkit = (String)projectWizard.getAutSettingWizardPage().getToolkitComboBox().getSelectedObject();
                        if (selectedToolkit == null) {
                            selectedToolkit = (String)projectWizard.getProjectSettingWizardPage().getToolkitComboBox().getSelectedObject();
                        }
                        NewProjectHandler.this.createWizardNagDialog(selectedToolkit);
                        super.finishPressed();
                    }

                    protected void nextPressed() {
                        if (projectWizard.getPage(projectWizard.getAutConfigSettingWpID()).equals(super.getCurrentPage())) {
                            String selectedToolkit = (String)projectWizard.getAutSettingWizardPage().getToolkitComboBox().getSelectedObject();
                            if (selectedToolkit == null) {
                                selectedToolkit = (String)projectWizard.getProjectSettingWizardPage().getToolkitComboBox().getSelectedObject();
                            }
                            NewProjectHandler.this.createWizardNagDialog(selectedToolkit);
                        }
                        super.nextPressed();
                    }
                };
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    IProjectPO project = GeneralStorage.getInstance().getProject();
                    OpenProjectHandler.OpenProjectOperation op = new OpenProjectHandler.OpenProjectOperation(project);
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        });
    }

    private void createWizardNagDialog(String selectedToolkit) {
        if (!this.m_alreadyNagged && this.isSwingOrSwtPlugin(selectedToolkit) && !JavaAutConfigComponent.isExecFieldEmpty()) {
            NagDialog.runNagDialog(null, "InfoNagger.DefineSwingOrSwtExecutable", "org.eclipse.jubula.client.ua.help.autConfigSettingWizardPagePageContextId");
            this.m_alreadyNagged = true;
        }
    }

    private boolean isSwingOrSwtPlugin(String selectedToolkit) {
        return selectedToolkit.equals("com.bredexsw.guidancer.SwingToolkitPlugin") || selectedToolkit.equals("com.bredexsw.guidancer.SwtToolkitPlugin");
    }

    public Object executeImpl(ExecutionEvent event) {
        this.m_alreadyNagged = false;
        if (GeneralStorage.getInstance().getProject() != null && Plugin.getDefault().anyDirtyStar() && !Plugin.getDefault().showSaveEditorDialog()) {
            return null;
        }
        this.openNewProjectWizard();
        return null;
    }
}

