/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.contentprovider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.AbstractTreeViewContentProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteBrowserContentProvider
extends AbstractTreeViewContentProvider {
    private static final Logger LOG = LoggerFactory.getLogger(TestSuiteBrowserContentProvider.class);

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IExecObjContPO[]) {
            return new Object[]{((IExecObjContPO[])parentElement)[0]};
        }
        if (parentElement instanceof IExecObjContPO) {
            IExecObjContPO execObjects = (IExecObjContPO)parentElement;
            ArrayList elements = new ArrayList();
            elements.addAll(execObjects.getExecObjList());
            return elements.toArray();
        }
        if (parentElement instanceof IExecTestCasePO) {
            ISpecTestCasePO referencedTestCase = ((IExecTestCasePO)parentElement).getSpecTestCase();
            if (referencedTestCase != null) {
                Collection eventTCs = Collections.unmodifiableCollection(referencedTestCase.getAllEventEventExecTC());
                List nodes = referencedTestCase.getUnmodifiableNodeList();
                return ArrayUtils.addAll((Object[])eventTCs.toArray(), (Object[])nodes.toArray());
            }
            return ArrayUtils.EMPTY_OBJECT_ARRAY;
        }
        if (parentElement instanceof ITestSuitePO) {
            ITestSuitePO testSuite = (ITestSuitePO)parentElement;
            Locale workLang = WorkingLanguageBP.getInstance().getWorkingLanguage();
            if (testSuite.getAut() != null && !WorkingLanguageBP.getInstance().isTestSuiteLanguage(workLang, testSuite)) {
                return ArrayUtils.EMPTY_OBJECT_ARRAY;
            }
        }
        if (parentElement instanceof INodePO) {
            List nodes = ((INodePO)parentElement).getUnmodifiableNodeList();
            return nodes.toArray();
        }
        LOG.error("Wrong type for parent element: " + parentElement);
        return ArrayUtils.EMPTY_OBJECT_ARRAY;
    }
}

