/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.labelprovider;

import java.util.Iterator;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.swt.graphics.Image;

public class CentralTestDataLabelProvider
extends GeneralLabelProvider {
    public String getText(Object element) {
        if (element instanceof IParameterInterfacePO) {
            IParameterInterfacePO tdc = (IParameterInterfacePO)element;
            StringBuilder info = new StringBuilder(tdc.getName());
            Iterator iter = tdc.getParameterList().iterator();
            boolean parameterExist = false;
            if (iter.hasNext()) {
                parameterExist = true;
                info.append(" [");
            }
            if (iter.hasNext()) {
                while (iter.hasNext()) {
                    IParamDescriptionPO descr = (IParamDescriptionPO)iter.next();
                    info.append(CompSystemI18n.getString((String)descr.getType(), (boolean)true));
                    info.append(":");
                    info.append(descr.getName());
                    if (!iter.hasNext()) continue;
                    info.append("; ");
                }
            }
            if (parameterExist) {
                info.append("]");
            }
            return info.toString();
        }
        if (element instanceof ITestDataCategoryPO) {
            return ((ITestDataCategoryPO)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof ITestDataCubePO) {
            return IconConstants.TDC_IMAGE;
        }
        if (element instanceof ITestDataCategoryPO) {
            return IconConstants.CATEGORY_IMAGE;
        }
        return super.getImage(element);
    }
}

