/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.labelprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.model.ICompIdentifierPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.constants.RcpIconConstants;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.i18n.I18n;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class OMEditorTreeLabelProvider
extends LabelProvider {
    private static Map<String, String> topLevelCategoryToNameKey = new HashMap<String, String>();
    private IComponentNameMapper m_compMapper;
    private Clipboard m_clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());

    static {
        topLevelCategoryToNameKey.put("#1!mappedGDCat#1!", "ObjectMappingEditor.Assigned");
        topLevelCategoryToNameKey.put("#1!unmappedlogicalGDCat#1!", "ObjectMappingEditor.UnAssignedLogic");
        topLevelCategoryToNameKey.put("#1!mappedtechnicalGDCat#1!", "ObjectMappingEditor.UnAssignedTech");
    }

    public OMEditorTreeLabelProvider(IComponentNameMapper compMapper) {
        this.m_compMapper = compMapper;
    }

    public void dispose() {
        this.m_clipboard.dispose();
    }

    public Image getImage(Object element) {
        IStructuredSelection sel;
        Image image = null;
        if (element instanceof IComponentNamePO) {
            image = IconConstants.LOGICAL_NAME_IMAGE;
        } else if (element instanceof IObjectMappingAssoziationPO) {
            int status = OMEditorTreeLabelProvider.getQualitySeverity(((IObjectMappingAssoziationPO)element).getCompIdentifier());
            switch (status) {
                case 0: {
                    image = IconConstants.TECH_NAME_OK_IMAGE;
                    break;
                }
                case 2: {
                    image = IconConstants.TECH_NAME_WARNING_IMAGE;
                    break;
                }
                case 4: {
                    image = IconConstants.TECH_NAME_ERROR_IMAGE;
                    break;
                }
                default: {
                    image = IconConstants.TECHNICAL_NAME_IMAGE;
                    break;
                }
            }
        } else if (element instanceof IObjectMappingCategoryPO) {
            image = IconConstants.CATEGORY_IMAGE;
        } else if (element instanceof String) {
            image = IconConstants.LOGICAL_NAME_IMAGE;
        } else {
            String elementType = element != null ? element.getClass().getName() : "null";
            StringBuilder msg = new StringBuilder();
            msg.append(org.eclipse.jubula.client.ui.rcp.i18n.Messages.ElementType).append(" ").append("'").append(elementType).append("'").append(" ").append(org.eclipse.jubula.client.ui.rcp.i18n.Messages.NotSupported).append(".");
            Assert.notReached((String)msg.toString());
            return null;
        }
        Object cbContents = this.m_clipboard.getContents((Transfer)LocalSelectionClipboardTransfer.getInstance());
        if (cbContents instanceof IStructuredSelection && (sel = (IStructuredSelection)cbContents).toList().contains(element)) {
            image = RcpIconConstants.getCutImage(image);
        }
        return image;
    }

    public static int getQualitySeverity(IComponentIdentifier identifier) {
        if (identifier != null) {
            int noOfMatchedComps = identifier.getNumberOfOtherMatchingComponents();
            if (identifier.isEqualOriginalFound()) {
                if (noOfMatchedComps == 1) {
                    return 0;
                }
                return 2;
            }
            return 4;
        }
        return 8;
    }

    public String getText(Object element) {
        if (element instanceof IObjectMappingAssoziationPO) {
            ICompIdentifierPO compId = ((IObjectMappingAssoziationPO)element).getTechnicalName();
            if (compId != null) {
                return compId.getComponentNameToDisplay();
            }
        } else {
            if (element instanceof IComponentNamePO) {
                return this.m_compMapper.getCompNameCache().getName(((IComponentNamePO)element).getGuid());
            }
            if (element instanceof IObjectMappingCategoryPO) {
                IObjectMappingCategoryPO category = (IObjectMappingCategoryPO)element;
                StringBuilder nameBuilder = new StringBuilder();
                String catName = category.getName();
                if (OMEditorTreeLabelProvider.getTopLevelCategoryName(catName) != null) {
                    catName = OMEditorTreeLabelProvider.getTopLevelCategoryName(catName);
                }
                nameBuilder.append(catName);
                if (Plugin.getDefault().getPreferenceStore().getBoolean("SHOWCHILDCOUNT_PREF_KEY")) {
                    int childListSize = 0;
                    childListSize += category.getUnmodifiableAssociationList().size();
                    nameBuilder.append(" (").append(childListSize += category.getUnmodifiableCategoryList().size()).append(")");
                }
                return nameBuilder.toString();
            }
            if (element instanceof String) {
                return (String)element;
            }
        }
        Assert.notReached((String)(String.valueOf(Messages.UnknownTypeOfElementInTreeOfType) + " " + element.getClass().getName()));
        return "";
    }

    public static String getTopLevelCategoryName(String key) {
        if (topLevelCategoryToNameKey.containsKey(key)) {
            return I18n.getString((String)topLevelCategoryToNameKey.get(key));
        }
        return null;
    }
}

