/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.GeneralLabelProvider;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractQuery
implements ISearchQuery {
    private String m_viewId;
    private String m_timestamp;
    private IProgressMonitor m_monitor;
    private Set<INodePO> m_resultNodeSet = new HashSet<INodePO>();
    private List<BasicSearchResult.SearchResultElement> m_resultTestDataCubes = new ArrayList<BasicSearchResult.SearchResultElement>();
    private BasicSearchResult m_searchResult = new BasicSearchResult(this);

    public AbstractQuery() {
        this.m_timestamp = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date());
    }

    public AbstractQuery(String viewId) {
        this.m_viewId = viewId;
        this.m_timestamp = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss").format(new Date());
    }

    public String getTimestamp() {
        return this.m_timestamp;
    }

    protected void setMonitor(IProgressMonitor monitor) {
        monitor.beginTask(Messages.SimpleSearchBeginTask, -1);
        this.m_monitor = monitor;
        this.m_resultNodeSet.clear();
        this.m_resultTestDataCubes.clear();
    }

    protected IProgressMonitor getMonitor() {
        return this.m_monitor;
    }

    protected void add(INodePO node) {
        this.m_resultNodeSet.add(node);
    }

    protected void add(IParameterInterfacePO testDataCube) {
        this.m_resultTestDataCubes.add(new BasicSearchResult.SearchResultElement<Long>(testDataCube.getName(), testDataCube.getId(), GeneralLabelProvider.getImageImpl(testDataCube), new BasicSearchResult.TestDataCubeSearchResultElementAction(), null, "org.eclipse.jubula.client.ui.rcp.views.DataSetView"));
    }

    protected void addAll(Set<INodePO> nodes) {
        for (INodePO node : nodes) {
            this.add(node);
        }
    }

    protected void setSearchResult(List<BasicSearchResult.SearchResultElement> reuseLoc) {
        this.m_searchResult.setResultList(reuseLoc);
    }

    protected void finished() {
        List<BasicSearchResult.SearchResultElement> result = this.getSearchResultListFromNodes(this.m_resultNodeSet);
        result.addAll(this.m_resultTestDataCubes);
        this.setSearchResult(result);
        this.getMonitor().done();
    }

    protected List<BasicSearchResult.SearchResultElement> getSearchResultListFromNodes(Set<INodePO> reuse) {
        ArrayList<BasicSearchResult.SearchResultElement> searchResult = new ArrayList<BasicSearchResult.SearchResultElement>(reuse.size());
        for (INodePO node : reuse) {
            INodePO parent = node.getParentNode();
            String nodeName = GeneralLabelProvider.getTextImpl(node);
            String resultName = AbstractQuery.validParent(parent) ? NLS.bind((String)Messages.SearchResultPageElementLabel, (Object[])new Object[]{parent.getName(), nodeName}) : nodeName;
            searchResult.add(new BasicSearchResult.SearchResultElement<Long>(resultName, node.getId(), GeneralLabelProvider.getImageImpl(node), new BasicSearchResult.NodeSearchResultElementAction(), node.getComment(), this.m_viewId));
        }
        return searchResult;
    }

    private static boolean validParent(INodePO parent) {
        return parent != null && !(parent instanceof IProjectPO);
    }

    public boolean isEmpty() {
        return this.m_resultNodeSet.isEmpty() && this.m_resultTestDataCubes.isEmpty();
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        return this.m_searchResult;
    }
}

