/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.sourceprovider;

import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jubula.client.core.agent.AutAgentRegistration;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.client.ui.rcp.utils.HTMLAutWindowManager;
import org.eclipse.jubula.tools.registration.AutIdentifier;

public class HTMLAutSourceProvider
extends AbstractJBSourceProvider
implements DataEventDispatcher.IOMAUTListener,
DataEventDispatcher.IOMStateListener,
DataEventDispatcher.IOMWindowsListener {
    public static final String ID = "org.eclipse.jubula.client.ui.rcp.sourceprovider.HTMLAutSourceProvider";
    public static final String IS_HTML_AUT = "org.eclipse.jubula.client.ui.rcp.variable.isHtmlAut";
    public static final String WINDOW_TITLES = "org.eclipse.jubula.client.ui.rcp.variable.html.windowCount";
    private boolean m_isHTMLAut = false;
    private String m_lastSelectedWindow = null;

    public HTMLAutSourceProvider() {
        DataEventDispatcher dispatch = DataEventDispatcher.getInstance();
        dispatch.addOMAUTListener((DataEventDispatcher.IOMAUTListener)this, false);
        dispatch.addOMStateListener((DataEventDispatcher.IOMStateListener)this, true);
        dispatch.addAUTWindowsListener((DataEventDispatcher.IOMWindowsListener)this, false);
        HTMLAutWindowManager.getInstance();
    }

    public void dispose() {
        DataEventDispatcher dispatch = DataEventDispatcher.getInstance();
        dispatch.removeOMAUTListener((DataEventDispatcher.IOMAUTListener)this);
        dispatch.removeOMStateListener((DataEventDispatcher.IOMStateListener)this);
        dispatch.removeAUTWindowsListener((DataEventDispatcher.IOMWindowsListener)this);
    }

    public Map getCurrentState() {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        values.put(IS_HTML_AUT, Boolean.valueOf(this.m_isHTMLAut));
        values.put(WINDOW_TITLES, new LinkedList());
        return values;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_HTML_AUT};
    }

    public void handleAUTChanged(AutIdentifier identifier) {
        IProjectPO project;
        IAUTMainPO aut;
        String toolkit;
        this.m_isHTMLAut = identifier != null ? (toolkit = (aut = AutAgentRegistration.getAutForId((AutIdentifier)identifier, (IProjectPO)(project = GeneralStorage.getInstance().getProject()))).getToolkit()).equalsIgnoreCase("com.bredexsw.guidancer.HtmlToolkitPlugin") : false;
        this.fireModeChanged();
    }

    public void handleOMStateChanged(DataEventDispatcher.OMState state) {
        if (state == DataEventDispatcher.OMState.notRunning) {
            this.m_isHTMLAut = false;
        }
    }

    private void fireModeChanged() {
        this.gdFireSourceChanged(0, IS_HTML_AUT, this.m_isHTMLAut);
    }

    public void handleAUTChanged(String[] windowTitles) {
        LinkedList<String> listOfTitles = new LinkedList<String>();
        int i = 0;
        while (i < windowTitles.length) {
            listOfTitles.add(windowTitles[i]);
            ++i;
        }
        this.gdFireSourceChanged(0, WINDOW_TITLES, listOfTitles);
    }
}

