/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.validator;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Text;

public class TestDataCubeReferenceValidator
implements CheckedText.IValidator {
    private IProjectPO m_project;

    public TestDataCubeReferenceValidator(IProjectPO project) {
        Validate.notNull((Object)project);
        this.m_project = project;
    }

    public CheckedText.ValidationState validateInput(VerifyEvent e) {
        Text txt = (Text)e.widget;
        StringBuilder workValue = new StringBuilder(txt.getText());
        workValue.replace(e.start, e.end, e.text);
        String newValue = workValue.toString();
        boolean mightMatch = false;
        ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)this.m_project);
        int n = iTestDataCubePOArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITestDataCubePO dataCube = iTestDataCubePOArray[n2];
            if (StringUtils.equals((String)e.text, (String)dataCube.getName())) {
                return CheckedText.ValidationState.OK;
            }
            if (!mightMatch && StringUtils.startsWith((String)dataCube.getName(), (String)newValue)) {
                mightMatch = true;
            }
            ++n2;
        }
        if (mightMatch) {
            return CheckedText.ValidationState.MightMatchAccept;
        }
        return CheckedText.ValidationState.MightMatchReject;
    }
}

