/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.text.MessageFormat;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.CompNamePopUpTextField;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class CompNamePopupTextCellEditor
extends CellEditor {
    private static final int DEFAULT_STYLE = 4;
    private CompNamePopUpTextField m_popupText;
    private ModifyListener m_modifyListener;
    private boolean m_isSelection = false;
    private boolean m_isDeleteable = false;
    private boolean m_isSelectable = false;
    private String m_lastValidValue;
    private IComponentNameMapper m_compMapper;

    public CompNamePopupTextCellEditor(IComponentNameMapper compMapper, Composite parent) {
        super(parent, 4);
        this.setComponentNameMapper(compMapper);
        this.m_lastValidValue = "";
    }

    private void checkDeleteable() {
        boolean oldIsDeleteable = this.m_isDeleteable;
        this.m_isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.m_isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    private void checkSelectable() {
        boolean oldIsSelectable = this.m_isSelectable;
        this.m_isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.m_isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    public void setFilter(String filter) {
        this.m_popupText.setFilter(filter);
    }

    private void checkSelection() {
        boolean oldIsSelection = this.m_isSelection;
        boolean bl = this.m_isSelection = this.m_popupText.getSelectionCount() > 0;
        if (oldIsSelection != this.m_isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected Control createControl(Composite parent) {
        this.m_popupText = new CompNamePopUpTextField(this.m_compMapper, parent, this.getStyle());
        this.m_popupText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CompNamePopupTextCellEditor.this.handleDefaultSelection();
            }
        });
        this.m_popupText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CompNamePopupTextCellEditor.this.keyReleaseOccured(e);
                if (CompNamePopupTextCellEditor.this.getControl() == null || CompNamePopupTextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                CompNamePopupTextCellEditor.this.checkSelection();
                CompNamePopupTextCellEditor.this.checkDeleteable();
                CompNamePopupTextCellEditor.this.checkSelectable();
            }
        });
        this.m_popupText.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.m_popupText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                CompNamePopupTextCellEditor.this.checkSelection();
                CompNamePopupTextCellEditor.this.checkDeleteable();
                CompNamePopupTextCellEditor.this.checkSelectable();
            }
        });
        this.m_popupText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                CompNamePopupTextCellEditor.this.focusLost();
            }

            public void focusGained(FocusEvent e) {
                super.focusGained(e);
            }
        });
        this.m_popupText.setFont(parent.getFont());
        this.m_popupText.setBackground(parent.getBackground());
        this.m_popupText.setText("");
        this.m_popupText.addModifyListener(this.getModifyListener());
        return this.m_popupText;
    }

    protected Object doGetValue() {
        return this.m_popupText.getText();
    }

    protected void doSetFocus() {
        if (this.m_popupText != null) {
            this.m_popupText.selectAll();
            this.m_popupText.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.verify((this.m_popupText != null ? 1 : 0) != 0);
        String v = (String)value;
        if (v == null) {
            v = "";
        }
        this.m_popupText.removeModifyListener(this.getModifyListener());
        this.m_popupText.setText(v);
        this.m_popupText.setData("INITPOPUP", false);
        this.m_popupText.addModifyListener(this.getModifyListener());
        this.m_lastValidValue = v;
    }

    protected void editOccured() {
        String value = this.m_popupText.getText();
        if (value == null) {
            value = "";
        }
        boolean oldValidState = this.isValueValid();
        boolean newValidState = this.isCorrect(value);
        if (value == null && newValidState) {
            Assert.verify((boolean)false, (String)Messages.ValidatorIsntLimitingTheCellEditorsTypeRange);
        }
        if (!newValidState) {
            this.setErrorMessage(MessageFormat.format(this.getErrorMessage(), value));
        }
        this.valueChanged(oldValidState, newValidState);
    }

    protected void fireApplyEditorValue() {
        String errorMsg = this.getErrorMessage();
        if (errorMsg != null) {
            this.setValue(this.m_lastValidValue);
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_INCOMPATIBLE_COMP_TYPE, null, (String[])new String[]{errorMsg});
        }
        super.fireApplyEditorValue();
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }

    private ModifyListener getModifyListener() {
        if (this.m_modifyListener == null) {
            this.m_modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CompNamePopupTextCellEditor.this.editOccured();
                }
            };
        }
        return this.m_modifyListener;
    }

    protected void handleDefaultSelection() {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    public boolean isCopyEnabled() {
        if (this.m_popupText == null || this.m_popupText.isDisposed()) {
            return false;
        }
        return this.m_popupText.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.m_popupText == null || this.m_popupText.isDisposed()) {
            return false;
        }
        return this.m_popupText.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.m_popupText == null || this.m_popupText.isDisposed()) {
            return false;
        }
        return this.m_popupText.getSelectionCount() > 0 || this.m_popupText.getCaretPosition() < this.m_popupText.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.m_popupText != null && !this.m_popupText.isDisposed();
    }

    public boolean isSaveAllEnabled() {
        return this.m_popupText != null && !this.m_popupText.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.m_popupText == null || this.m_popupText.isDisposed()) {
            return false;
        }
        return this.m_popupText.getCharCount() > 0;
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.m_popupText != null && !this.m_popupText.isDisposed() && (this.m_popupText.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public void performCopy() {
        this.m_popupText.copy();
    }

    public void performCut() {
        this.m_popupText.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.m_popupText.getSelectionCount() > 0) {
            this.m_popupText.insert("");
        } else {
            int pos = this.m_popupText.getCaretPosition();
            if (pos < this.m_popupText.getCharCount()) {
                this.m_popupText.setSelection(pos, pos + 1);
                this.m_popupText.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.m_popupText.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.m_popupText.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }

    public void setSelectable(boolean isSelectable) {
        this.m_isSelectable = isSelectable;
    }

    public void setComponentNameMapper(IComponentNameMapper compMapper) {
        this.m_popupText.setComponentNameMapper(compMapper);
        this.m_compMapper = compMapper;
    }

    protected void focusLost() {
        if (!this.m_popupText.isPopupOpen()) {
            super.focusLost();
        }
    }

    protected boolean dependsOnExternalFocusListener() {
        return false;
    }
}

