/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.dialogs;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jubula.client.ui.dialogs.AbstractValidatedDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EnterCommentDialog
extends AbstractValidatedDialog {
    private WritableValue m_commentTitle;
    private WritableValue m_commentDetail;
    private String m_initialTitle = null;
    private String m_initialDetail = null;
    private IValidator m_validator;

    public EnterCommentDialog(Shell parentShell, IValidator commentValidator, String title, String detail) {
        super(parentShell);
        this.m_validator = commentValidator;
        this.m_initialTitle = title;
        this.m_initialDetail = detail;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.EnterCommentDialogTitle);
        this.setMessage(Messages.EnterCommentDialogMessage);
        this.getShell().setText(Messages.EnterCommentDialogTitle);
        GridData gridData = new GridData(4, 4, true, true);
        Composite area = new Composite(parent, 2048);
        area.setLayoutData((Object)gridData);
        area.setLayout((Layout)new GridLayout(2, false));
        this.createCommentTitleField(area);
        this.createCommentDetailField(area);
        return area;
    }

    protected Point getInitialSize() {
        Point shellSize = super.getInitialSize();
        return new Point(Math.max(this.convertHorizontalDLUsToPixels(450), shellSize.x), Math.max(this.convertVerticalDLUsToPixels(300), shellSize.y));
    }

    protected boolean isResizable() {
        return true;
    }

    private void createCommentTitleField(Composite area) {
        Text commentTitleField = this.createCommentTitleText(area);
        GridData gridData = new GridData(4, 4, true, false);
        LayoutUtil.addToolTipAndMaxWidth(gridData, (Control)commentTitleField);
        commentTitleField.setLayoutData((Object)gridData);
        ISWTObservableValue commentTitleFieldText = SWTObservables.observeText((Control)commentTitleField, (int)24);
        this.m_commentTitle = WritableValue.withValueType(String.class);
        this.getValidationContext().bindValue((IObservableValue)commentTitleFieldText, (IObservableValue)this.m_commentTitle, new UpdateValueStrategy().setAfterGetValidator(this.m_validator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        if (!StringUtils.isEmpty((String)this.m_initialTitle)) {
            this.m_commentTitle.setValue((Object)this.m_initialTitle);
        }
        LayoutUtil.setMaxChar(commentTitleField, 4000);
        commentTitleField.selectAll();
    }

    private void createCommentDetailField(Composite area) {
        Text commentDetailField = this.createCommentDetailText(area);
        GridData gridData = new GridData(4, 4, true, true);
        LayoutUtil.addToolTipAndMaxWidth(gridData, (Control)commentDetailField);
        commentDetailField.setLayoutData((Object)gridData);
        ISWTObservableValue commentDetailFieldText = SWTObservables.observeText((Control)commentDetailField, (int)24);
        this.m_commentDetail = WritableValue.withValueType(String.class);
        this.getValidationContext().bindValue((IObservableValue)commentDetailFieldText, (IObservableValue)this.m_commentDetail, new UpdateValueStrategy().setAfterGetValidator(this.m_validator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE));
        if (!StringUtils.isEmpty((String)this.m_initialDetail)) {
            this.m_commentDetail.setValue((Object)this.m_initialDetail);
        }
        LayoutUtil.setMaxChar(commentDetailField, 4000);
    }

    private Text createCommentTitleText(Composite area) {
        new Label(area, 0).setText(Messages.EnterCommentDialogTitleLabel);
        return new Text(area, 2052);
    }

    private Text createCommentDetailText(Composite area) {
        new Label(area, 0).setText(Messages.EnterCommentDialogDetailLabel);
        return new Text(area, 2560);
    }

    public String getCommentTitle() {
        return (String)this.m_commentTitle.getValue();
    }

    public String getCommentDetail() {
        return (String)this.m_commentDetail.getValue();
    }
}

