/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.launch;

import java.net.InetSocketAddress;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jubula.client.core.communication.AutAgentConnection;
import org.eclipse.jubula.client.core.communication.ConnectionException;
import org.eclipse.jubula.communication.Communicator;
import org.eclipse.jubula.launch.i18n.Messages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutLaunchUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AutLaunchUtils.class);

    private AutLaunchUtils() {
    }

    public static InetSocketAddress verifyConnectedAgentAddress() throws CoreException {
        Job[] connectToAgentJobs;
        InetSocketAddress addr = AutLaunchUtils.getConnectedAgentAddress();
        if (addr != null) {
            return addr;
        }
        LOG.info("Not connected to an AUT Agent. Connecting to embedded AUT Agent.");
        IHandlerService handlerServce = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerServce.executeCommand("org.eclipse.jubula.client.autagent.commands.ConnectToEmbeddedAutAgent", null);
        }
        catch (CommandException e) {
            LOG.error("Error occurred while trying to connect to embedded AUT Agent.", (Throwable)e);
        }
        Job[] jobArray = connectToAgentJobs = Job.getJobManager().find(AutAgentConnection.CONNECT_TO_AGENT_JOB_FAMILY_ID);
        int n = connectToAgentJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job connectJob = jobArray[n2];
            try {
                connectJob.join();
            }
            catch (InterruptedException ie) {
                LOG.warn("Interrupt occurred while waiting for connection to AUT Agent.", (Throwable)ie);
                Thread.currentThread().interrupt();
            }
            ++n2;
        }
        addr = AutLaunchUtils.getConnectedAgentAddress();
        if (addr == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jubula.launch", Messages.LaunchAutError_NoAgentConnection));
        }
        return addr;
    }

    private static InetSocketAddress getConnectedAgentAddress() {
        try {
            Communicator agentCommunicator = AutAgentConnection.getInstance().getCommunicator();
            if (agentCommunicator.getConnection() != null) {
                return new InetSocketAddress(agentCommunicator.getHostName(), agentCommunicator.getPort());
            }
        }
        catch (ConnectionException connectionException) {}
        return null;
    }

    public static String getAutId(ILaunchConfiguration configuration) {
        String autId = configuration.getName();
        try {
            String definedAutId = configuration.getAttribute("org.eclipse.jubula.launch.AUT_ID", "");
            if (!StringUtils.isEmpty((String)definedAutId)) {
                autId = definedAutId;
            }
        }
        catch (CoreException ce) {
            LOG.error(Messages.GetAutIdFromLaunchConfigError, (Throwable)ce);
        }
        return autId;
    }
}

