/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.adapter;

import javax.swing.text.JTextComponent;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITextInputComponent;
import org.eclipse.jubula.rc.swing.tester.adapter.JComponentAdapter;

public class JTextComponentAdapter
extends JComponentAdapter
implements ITextInputComponent {
    private JTextComponent m_textComponent;

    public JTextComponentAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_textComponent = (JTextComponent)objectToAdapt;
    }

    public String getText() {
        return this.m_textComponent.getText();
    }

    public void setSelection(final int position) {
        this.getEventThreadQueuer().invokeAndWait("setSelection", new IRunnable(){

            public Object run() {
                JTextComponentAdapter.this.m_textComponent.setCaretPosition(position);
                return null;
            }
        });
    }

    public void setSelection(final int start, final int end) {
        this.getEventThreadQueuer().invokeAndWait("setSelection", new IRunnable(){

            public Object run() {
                JTextComponentAdapter.this.m_textComponent.setSelectionStart(start);
                JTextComponentAdapter.this.m_textComponent.setSelectionEnd(end);
                return null;
            }
        });
    }

    public String getSelectionText() {
        String actual = (String)this.getEventThreadQueuer().invokeAndWait("getSelectionText", new IRunnable(){

            public Object run() {
                return JTextComponentAdapter.this.m_textComponent.getSelectedText();
            }
        });
        return actual;
    }

    public void selectAll() {
        this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
        if (!this.getText().equals(this.getSelectionText())) {
            this.getEventThreadQueuer().invokeAndWait("selectAll", new IRunnable(){

                public Object run() {
                    JTextComponentAdapter.this.m_textComponent.selectAll();
                    return null;
                }
            });
        }
    }

    public boolean isEditable() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isEditable", new IRunnable(){

            public Object run() {
                return JTextComponentAdapter.this.m_textComponent.isEditable() && JTextComponentAdapter.this.m_textComponent.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }
}

