/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.DBPlatformHelper;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.server.NoServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class DatabaseSessionImpl
extends AbstractSession
implements DatabaseSession {
    private SequencingHome sequencingHome;
    private ServerPlatform serverPlatform;
    private long connectedTime;
    protected volatile boolean isLoggedIn;

    protected void setSequencingHome(SequencingHome sequencingHome) {
        this.sequencingHome = sequencingHome;
    }

    protected SequencingHome getSequencingHome() {
        if (this.sequencingHome == null) {
            this.setSequencingHome(SequencingFactory.createSequencingHome(this));
        }
        return this.sequencingHome;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public SequencingControl getSequencingControl() {
        return this.getSequencingHome().getSequencingControl();
    }

    public Sequencing getSequencing() {
        return this.getSequencingHome().getSequencing();
    }

    public boolean isSequencingCallbackRequired() {
        return this.getSequencingHome().isSequencingCallbackRequired();
    }

    public void initializeSequencing() {
        this.getSequencingHome().onDisconnect();
        this.getSequencingHome().onConnect();
    }

    public void addDescriptorsToSequencing(Collection descriptors) {
        this.getSequencingHome().onAddDescriptors(descriptors);
    }

    public void releaseJTSConnection() {
        this.getAccessor().closeJTSConnection();
    }

    public DatabaseSessionImpl() {
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public DatabaseSessionImpl(Login login) {
        this(new Project(login));
    }

    public DatabaseSessionImpl(Project project) {
        super(project);
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public void addDescriptor(ClassDescriptor descriptor) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptor(descriptor, this);
    }

    public void addDescriptors(Collection descriptors) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(descriptors, this);
    }

    public void addDescriptors(Project project) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(project, this);
    }

    public void addSequence(Sequence sequence) {
        this.getProject().getLogin().getDatasourcePlatform().addSequence(sequence, this.getSequencingHome().isConnected());
    }

    public void connect() throws DatabaseException {
        this.getAccessor().connect(this.getDatasourceLogin(), this);
    }

    public void disconnect() throws DatabaseException {
        this.getSequencingHome().onDisconnect();
        this.getAccessor().disconnect(this);
    }

    public ServerPlatform getServerPlatform() {
        return this.serverPlatform;
    }

    public void setServerPlatform(ServerPlatform newServerPlatform) {
        if (this.isLoggedIn) {
            throw ValidationException.serverPlatformIsReadOnlyAfterLogin(newServerPlatform.getClass().getName());
        }
        this.serverPlatform = newServerPlatform;
    }

    protected void finalize() throws DatabaseException {
        if (this.isConnected()) {
            this.logout();
        }
    }

    public DatabasePlatform getPlatform() {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getPlatform();
            } else {
                return this.getDatasourceLogin().getPlatform();
            }
        }
        return (DatabasePlatform)this.platform;
    }

    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getDatasourcePlatform();
            } else {
                return this.getDatasourceLogin().getDatasourcePlatform();
            }
        }
        return this.platform;
    }

    public Platform getPlatform(Class domainClass) {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getDatasourcePlatform();
            } else {
                return this.getDatasourceLogin().getDatasourcePlatform();
            }
        }
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptorIfSessionAlive(ClassDescriptor descriptor) {
        if (this.isConnected() && descriptor.requiresInitialization()) {
            try {
                try {
                    ArrayList<ClassDescriptor> descriptorsToAdd = new ArrayList<ClassDescriptor>(1);
                    descriptorsToAdd.add(descriptor);
                    this.addDescriptorsToSequencing(descriptorsToAdd);
                    descriptor.preInitialize(this);
                    descriptor.initialize(this);
                    descriptor.postInitialize(this);
                    this.getCommitManager().initializeCommitOrder();
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
                if (this.getIntegrityChecker().hasErrors()) {
                    this.handleException(new IntegrityException(this.getIntegrityChecker()));
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.clearIntegrityChecker();
                throw throwable;
            }
            this.clearIntegrityChecker();
            {
            }
        }
    }

    public void initializeDescriptors() {
        this.initializeDescriptors((Map)((HashMap)this.getDescriptors()).clone(), true);
        for (PartitioningPolicy policy : this.getProject().getPartitioningPolicies().values()) {
            policy.initialize(this);
        }
        this.processJPAQueries();
    }

    public void initializeDescriptors(Map descriptors) {
        this.initializeDescriptors(descriptors.values(), false);
    }

    public void initializeDescriptors(Collection descriptors) {
        this.initializeDescriptors(descriptors, false);
    }

    public void initializeDescriptors(Map descriptors, boolean shouldInitializeSequencing) {
        this.initializeDescriptors(descriptors.values(), shouldInitializeSequencing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Collection descriptors, boolean shouldInitializeSequencing) {
        if (shouldInitializeSequencing) {
            this.initializeSequencing();
        } else {
            this.addDescriptorsToSequencing(descriptors);
        }
        try {
            AbstractSession session;
            for (ClassDescriptor descriptor : descriptors) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (descriptor.requiresInitialization()) {
                        descriptor.preInitialize(session);
                    }
                    if (!descriptor.isDescriptorTypeAggregate() || !descriptor.isChildDescriptor()) continue;
                    descriptor.initializeAggregateInheritancePolicy(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            for (ClassDescriptor descriptor : descriptors) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.initialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            for (ClassDescriptor descriptor : descriptors) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.postInitialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleSevere(new IntegrityException(this.getIntegrityChecker()));
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.clearIntegrityChecker();
            throw throwable;
        }
        this.clearIntegrityChecker();
        this.getCommitManager().initializeCommitOrder();
    }

    public boolean isDatabaseSession() {
        return true;
    }

    public boolean isProtectedSession() {
        return false;
    }

    protected Login getReadLogin() {
        return this.getDatasourceLogin();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loginAndDetectDatasource() throws DatabaseException {
        block9: {
            this.preConnectDatasource();
            Connection conn = null;
            try {
                try {
                    conn = (Connection)this.getReadLogin().connectToDatasource(null, this);
                    this.platform = null;
                    String platformName = null;
                    try {
                        String vendorNameAndVersion = conn.getMetaData().getDatabaseProductName() + conn.getMetaData().getDatabaseMajorVersion();
                        platformName = DBPlatformHelper.getDBPlatform(vendorNameAndVersion, this.getSessionLog());
                        this.getLogin().setPlatformClassName(platformName);
                    }
                    catch (EclipseLinkException classNotFound) {
                        if (platformName.indexOf("Oracle") == -1) throw classNotFound;
                        this.getLogin().setPlatformClassName(OraclePlatform.class.getName());
                    }
                    Object var5_7 = null;
                    if (conn == null) break block9;
                }
                catch (SQLException ex) {
                    DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                    dbEx.initCause(ex);
                    throw dbEx;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (conn == null) throw throwable;
                try {
                    conn.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                    dbEx.initCause(ex);
                    throw dbEx;
                }
            }
            try {}
            catch (SQLException ex) {
                DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                dbEx.initCause(ex);
                throw dbEx;
            }
            conn.close();
        }
        this.connect();
        this.postConnectDatasource();
    }

    public void login() throws DatabaseException {
        this.preConnectDatasource();
        this.connect();
        this.postConnectDatasource();
    }

    protected void preConnectDatasource() {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.platform = null;
        if (this.isInProfile()) {
            this.getProfiler().initialize();
        }
        this.updateProfile("Info:LoginTime", new Date(System.currentTimeMillis()));
        this.updateProfile("Info:SessionName", this.getName());
        if (this.eventManager != null) {
            this.eventManager.preLogin(this);
        }
        if (!this.hasBroker()) {
            this.getServerPlatform().initializeExternalTransactionController();
            this.log(5, null, "topLink_version", DatasourceLogin.getVersion());
            if (this.getServerPlatform().getServerNameAndVersion() != null && !this.getServerPlatform().getServerNameAndVersion().equals(ServerPlatformBase.DEFAULT_SERVER_NAME_AND_VERSION)) {
                this.log(5, null, "application_server_name_and_version", this.getServerPlatform().getServerNameAndVersion());
            }
        }
        this.isLoggingOff = this.getLogLevel() == 8;
    }

    protected void postConnectDatasource() {
        if (!this.hasBroker()) {
            this.initializeDescriptors();
            if (this.getCommandManager() != null) {
                this.getCommandManager().initialize();
            }
        }
        this.log(5, null, "login_successful", this.getName());
        if (!this.hasBroker()) {
            this.postLogin();
        }
        this.initializeConnectedTime();
        this.isLoggedIn = true;
        this.platform = null;
        if (!this.hasBroker()) {
            this.getServerPlatform().registerMBean();
        }
        this.descriptors = this.getDescriptors();
        if (!this.isBroker()) {
            this.getDatasourcePlatform().initialize();
            this.getIdentityMapAccessorInstance().getIdentityMapManager().checkIsCacheAccessPreCheckRequired();
        }
    }

    public void postLogin() {
        if (this.eventManager != null) {
            this.eventManager.postLogin(this);
        }
    }

    public void login(String userName, String password) throws DatabaseException {
        this.getDatasourceLogin().setUserName(userName);
        this.getDatasourceLogin().setPassword(password);
        this.login();
    }

    public void login(Login login) throws DatabaseException {
        this.setLogin(login);
        this.login();
    }

    public void logout() throws DatabaseException {
        this.lastDescriptorAccessed = null;
        if (this.isInTransaction()) {
            throw DatabaseException.logoutWhileTransactionInProgress();
        }
        if (this.getAccessor() == null) {
            return;
        }
        this.setShouldPropagateChanges(false);
        if (!this.hasBroker()) {
            if (this.getCommandManager() != null) {
                this.getCommandManager().shutdown();
            }
            this.getServerPlatform().unregisterMBean();
        }
        this.disconnect();
        this.getIdentityMapAccessor().initializeIdentityMaps();
        this.isLoggedIn = false;
        this.log(5, null, "logout_successful", this.getName());
    }

    public void initializeConnectedTime() {
        this.connectedTime = System.currentTimeMillis();
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    public void writeAllObjects(Collection domainObjects) throws DatabaseException, OptimisticLockException {
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            this.writeObject(objectsEnum.next());
        }
    }

    public void writeAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.writeObject(objectsEnum.nextElement());
        }
    }

    public Object retryQuery(DatabaseQuery query, AbstractRecord row, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        if (this.getClass() != DatabaseSessionImpl.class) {
            return super.retryQuery(query, row, databaseException, retryCount, executionSession);
        }
        int count = this.getLogin().getQueryRetryAttemptCount();
        while (retryCount < count) {
            try {
                databaseException.getAccessor().reestablishConnection(this);
            }
            catch (DatabaseException ex) {
                ++retryCount;
                try {
                    Thread.currentThread();
                    Thread.sleep(this.getLogin().getDelayBetweenConnectionAttempts());
                    this.log(5, "communication_failure_attempting_query_retry", (Object[])null, null);
                    continue;
                }
                catch (InterruptedException intEx) {}
            }
            break;
        }
        return executionSession.executeQuery(query, row, retryCount);
    }
}

