/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contentprovider.objectmapping.OMEditorTreeContentProvider;
import org.eclipse.jubula.client.ui.rcp.provider.labelprovider.OMEditorTreeLabelProvider;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class AssocOMtoSpecTCDialog
extends TitleAreaDialog {
    private Button m_selectionAvailableToUsedButton;
    private Button m_allAvailableToUsedButton;
    private Button m_selectionUsedToAvailableButton;
    private Button m_allUsedToAvailableButton;
    private IAUTMainPO m_autMain;
    private Combo m_autSelectorCombo;
    private List<IAUTMainPO> m_auts = new ArrayList<IAUTMainPO>();
    private TreeViewer m_availableTree;
    private TreeViewer m_usedTree;
    private Image[] m_activeButtonContents = new Image[]{IconConstants.RIGHT_ARROW_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_IMAGE, IconConstants.LEFT_ARROW_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_IMAGE};
    private Image[] m_disabledButtonContents = new Image[]{IconConstants.RIGHT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_RIGHT_ARROW_DIS_IMAGE, IconConstants.LEFT_ARROW_DIS_IMAGE, IconConstants.DOUBLE_LEFT_ARROW_DIS_IMAGE};
    private SelectionListener m_selectionListener = new WidgetSelectionListener();
    private Set<IObjectMappingCategoryPO> m_selectedCat = new HashSet<IObjectMappingCategoryPO>();

    public AssocOMtoSpecTCDialog(Shell parentShell, ISpecTestCasePO specTC) {
        super(parentShell);
        List omCategoryAssoc = specTC.getOmCategoryAssoc();
        this.m_selectedCat.addAll(omCategoryAssoc);
        if (omCategoryAssoc.size() > 0) {
            this.m_autMain = ((IObjectMappingCategoryPO)omCategoryAssoc.get(0)).getAutMainParent();
        } else {
            IProjectPO project = GeneralStorage.getInstance().getProject();
            Set autMainList = project.getAutMainList();
            if (autMainList.size() > 0) {
                this.m_autMain = (IAUTMainPO)autMainList.iterator().next();
            }
        }
        this.m_auts.addAll(GeneralStorage.getInstance().getProject().getAutMainList());
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.AssocOMtoSpecTCDialogTitle);
        this.getShell().setText(Messages.AssocOMtoSpecTCDialogTitle);
        this.setMessage(Messages.AssocOMtoSpecTCDialogMessage);
        Composite composite = new Composite(parent, 4);
        GridLayout parentLayout = new GridLayout(1, false);
        parent.setLayout((Layout)parentLayout);
        GridLayout compositeLayout = new GridLayout(1, false);
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)this.createGrabAllGridData());
        new Label(composite, 4);
        LayoutUtil.createSeparator((Composite)composite);
        this.m_autSelectorCombo = new Combo(composite, 8);
        this.m_autSelectorCombo.addSelectionListener(this.m_selectionListener);
        this.m_autSelectorCombo.setItems((String[])this.m_auts.stream().map(IAUTMainPO::getName).toArray(String[]::new));
        this.m_autSelectorCombo.setBounds(50, 50, 150, 65);
        this.m_autSelectorCombo.select(this.m_auts.indexOf(this.m_autMain));
        new Label(composite, 4);
        this.createLayout(composite);
        this.m_availableTree.setContentProvider((IContentProvider)new OMEditorTreeContentProvider(Plugin.getActiveCompCache(), this.m_selectedCat));
        this.m_availableTree.setInput((Object)this.m_autMain.getObjMap().getMappedCategory());
        this.m_usedTree.setInput(this.m_selectedCat);
        this.checkButtons();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.assignOMCategoriesToSpec");
        this.setHelpAvailable(true);
        return parent;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        initialSize.x = 800;
        initialSize.y = 600;
        return initialSize;
    }

    private void createLayout(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 3;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        composite.setLayoutData((Object)this.createGrabAllGridData());
        Composite compositeLeft = this.createComposite(composite, 1, 4, true);
        Composite compositeMiddle = this.createComposite(composite, 1, 4, false);
        Composite compositeRight = this.createComposite(composite, 1, 4, true);
        this.m_availableTree = this.createTree(compositeLeft, Messages.AssocOMtoSpecTCDialogAvailableCat, 10);
        this.m_availableTree.getTree().addSelectionListener(this.m_selectionListener);
        this.createShiftButtons(compositeMiddle);
        this.m_usedTree = this.createTree(compositeRight, Messages.AssocOMtoSpecTCDialogSelectedCat, 10);
        this.m_usedTree.getTree().addSelectionListener(this.m_selectionListener);
    }

    private Composite createComposite(Composite parent, int numColumns, int alignment, boolean horizontalSpace) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = alignment;
        compositeData.grabExcessHorizontalSpace = horizontalSpace;
        composite.setLayoutData((Object)compositeData);
        return composite;
    }

    private void createShiftButtons(Composite parent) {
        this.createLabel(parent, "");
        this.m_selectionAvailableToUsedButton = new Button(parent, 8);
        this.m_selectionAvailableToUsedButton.addSelectionListener(this.m_selectionListener);
        this.m_selectionAvailableToUsedButton.setLayoutData((Object)this.createButtonGridData());
        this.m_allAvailableToUsedButton = new Button(parent, 8);
        this.m_allAvailableToUsedButton.addSelectionListener(this.m_selectionListener);
        this.createLabel(parent, "");
        this.m_allAvailableToUsedButton.setLayoutData((Object)this.createButtonGridData());
        this.m_selectionUsedToAvailableButton = new Button(parent, 8);
        this.m_selectionUsedToAvailableButton.addSelectionListener(this.m_selectionListener);
        this.m_selectionUsedToAvailableButton.setLayoutData((Object)this.createButtonGridData());
        this.m_allUsedToAvailableButton = new Button(parent, 8);
        this.m_allUsedToAvailableButton.addSelectionListener(this.m_selectionListener);
        this.m_allUsedToAvailableButton.setLayoutData((Object)this.createButtonGridData());
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    private TreeViewer createTree(Composite composite, String labelText, int lines) {
        Composite firstComposite = this.createComposite(composite, 2, 1, false);
        Composite secondComposite = this.createComposite(composite, 1, 4, true);
        Label label = this.createLabel(firstComposite, labelText);
        secondComposite.setLayoutData((Object)this.createGrabAllGridData());
        composite.setLayoutData((Object)this.createGrabAllGridData());
        FilteredTree filtered = new FilteredTree(secondComposite, 2818, new PatternFilter(), true);
        TreeViewer tree = filtered.getViewer();
        tree.setAutoExpandLevel(3);
        tree.setData("Label", (Object)label);
        GridData treeGridData = this.createGrabAllGridData();
        treeGridData.widthHint = 300;
        IComponentNameCache activeCompCache = Plugin.getActiveCompCache();
        tree.setLabelProvider((IBaseLabelProvider)new OMEditorTreeLabelProvider(activeCompCache));
        tree.setContentProvider((IContentProvider)new OMEditorTreeContentProvider(activeCompCache));
        tree.getTree().setLayoutData((Object)treeGridData);
        return tree;
    }

    private GridData createButtonGridData() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        return gridData;
    }

    private GridData createGrabAllGridData() {
        return new GridData(4, 4, true, true);
    }

    private void checkButtons() {
        ITreeSelection selection = this.m_availableTree.getStructuredSelection();
        this.enableAvailableToUsedButton(!selection.isEmpty());
        for (Object type : selection) {
            if (type instanceof IObjectMappingCategoryPO) continue;
            this.enableAvailableToUsedButton(false);
            break;
        }
        ITreeSelection usedSelection = this.m_usedTree.getStructuredSelection();
        this.enableRemoveUsedButton(!usedSelection.isEmpty());
        for (Object type : usedSelection) {
            if (type instanceof IObjectMappingCategoryPO) continue;
            this.enableRemoveUsedButton(false);
            break;
        }
        this.enableRemoveAllUsedButton(this.m_selectedCat.size() > 0);
        this.enableAllAvailableToUsedButton(this.m_availableTree.getVisibleExpandedElements().length != this.m_availableTree.getTree().getItemCount());
    }

    private void enableAvailableToUsedButton(boolean enable) {
        this.enableButton(this.m_selectionAvailableToUsedButton, enable, this.m_activeButtonContents[0], this.m_disabledButtonContents[0]);
    }

    private void enableAllAvailableToUsedButton(boolean enable) {
        this.enableButton(this.m_allAvailableToUsedButton, enable, this.m_activeButtonContents[1], this.m_disabledButtonContents[1]);
    }

    private void enableRemoveUsedButton(boolean enable) {
        this.enableButton(this.m_selectionUsedToAvailableButton, enable, this.m_activeButtonContents[2], this.m_disabledButtonContents[2]);
    }

    private void enableRemoveAllUsedButton(boolean enable) {
        this.enableButton(this.m_allUsedToAvailableButton, enable, this.m_activeButtonContents[3], this.m_disabledButtonContents[3]);
    }

    private void enableButton(Button button, boolean enable, Image activeImage, Image disabledImage) {
        button.setEnabled(enable);
        if (enable) {
            button.setImage(activeImage);
        } else {
            button.setImage(disabledImage);
        }
    }

    private void handleSelectionAutSelectorEvent() {
        IAUTMainPO autMain = this.m_auts.get(this.m_autSelectorCombo.getSelectionIndex());
        if (!autMain.equals(this.m_autMain)) {
            this.m_autMain = autMain;
            this.m_selectedCat.clear();
            this.m_availableTree.setInput((Object)this.m_autMain.getObjMap().getMappedCategory());
            this.m_availableTree.refresh();
            this.m_usedTree.refresh();
            this.checkButtons();
        }
    }

    protected void handleSelectionAvailableToUsedButtonEvent() {
        if (this.m_selectionAvailableToUsedButton.isEnabled()) {
            ITreeSelection selection = this.m_availableTree.getStructuredSelection();
            for (IObjectMappingCategoryPO iObjectMappingCategoryPO : selection) {
                new ArrayList();
                Iterator<IObjectMappingCategoryPO> usedIterator = this.m_selectedCat.iterator();
                while (usedIterator.hasNext()) {
                    IObjectMappingCategoryPO selecteCat = usedIterator.next();
                    IObjectMappingCategoryPO parent = selecteCat.getParent();
                    while (parent != null) {
                        if (iObjectMappingCategoryPO.equals(parent)) {
                            usedIterator.remove();
                        }
                        parent = parent.getParent();
                    }
                }
                this.m_selectedCat.add(iObjectMappingCategoryPO);
            }
            this.m_usedTree.refresh();
            this.m_availableTree.refresh();
        }
    }

    protected void handleSelectionUsedToAvailableButtonEvent() {
        if (this.m_selectionUsedToAvailableButton.isEnabled()) {
            ITreeSelection selection = this.m_usedTree.getStructuredSelection();
            for (IObjectMappingCategoryPO iObjectMappingCategoryPO : selection) {
                this.m_selectedCat.remove(iObjectMappingCategoryPO);
            }
            this.m_usedTree.refresh();
            this.m_availableTree.refresh();
        }
    }

    private void handleSelectionAllUsedToAvailableButtonEvent() {
        if (this.m_allUsedToAvailableButton.isEnabled()) {
            this.m_selectedCat.clear();
            this.m_usedTree.refresh();
            this.m_availableTree.refresh();
        }
    }

    private void handleSelectionAllAvailableToUsedButtonEvent() {
        if (this.m_allAvailableToUsedButton.isEnabled()) {
            this.m_selectedCat.clear();
            this.m_selectedCat.addAll(this.m_autMain.getObjMap().getMappedCategory().getUnmodifiableCategoryList());
            this.m_usedTree.refresh();
            this.m_availableTree.refresh();
        }
    }

    public Collection<IObjectMappingCategoryPO> getSelectedItems() {
        return this.m_selectedCat;
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source.equals(AssocOMtoSpecTCDialog.this.m_availableTree.getTree()) || source.equals(AssocOMtoSpecTCDialog.this.m_usedTree.getTree())) {
                AssocOMtoSpecTCDialog.this.checkButtons();
            } else if (source.equals(AssocOMtoSpecTCDialog.this.m_selectionAvailableToUsedButton)) {
                AssocOMtoSpecTCDialog.this.handleSelectionAvailableToUsedButtonEvent();
            } else if (source.equals(AssocOMtoSpecTCDialog.this.m_selectionUsedToAvailableButton)) {
                AssocOMtoSpecTCDialog.this.handleSelectionUsedToAvailableButtonEvent();
            } else if (source.equals(AssocOMtoSpecTCDialog.this.m_allAvailableToUsedButton)) {
                AssocOMtoSpecTCDialog.this.handleSelectionAllAvailableToUsedButtonEvent();
            } else if (source.equals(AssocOMtoSpecTCDialog.this.m_allUsedToAvailableButton)) {
                AssocOMtoSpecTCDialog.this.handleSelectionAllUsedToAvailableButtonEvent();
            } else if (source.equals(AssocOMtoSpecTCDialog.this.m_autSelectorCombo)) {
                AssocOMtoSpecTCDialog.this.handleSelectionAutSelectorEvent();
            }
            AssocOMtoSpecTCDialog.this.checkButtons();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

