/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.search.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.core.businessprocess.TestDataBP;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.search.query.AbstractShowWhereUsedQuery;
import org.eclipse.jubula.client.ui.rcp.search.result.BasicSearchResult;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ShowWhereReferencedCTDSValueQuery
extends AbstractShowWhereUsedQuery
implements ITreeNodeOperation<INodePO> {
    private IParameterInterfacePO m_dataSet;
    private int m_row;
    private int m_col;
    private String m_colStr;
    private List<BasicSearchResult.SearchResultElement> m_exactResults;
    private List<BasicSearchResult.SearchResultElement> m_columnResults;
    private IProgressMonitor m_monitor;
    private int m_counter;

    public ShowWhereReferencedCTDSValueQuery(IParameterInterfacePO ctds, int row, int col) {
        super(null);
        this.m_dataSet = ctds;
        this.m_row = row;
        this.m_col = col;
        this.m_colStr = (String)this.m_dataSet.getParamNames().get(this.m_col);
    }

    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (this.m_monitor == null) {
            ++this.m_counter;
            return true;
        }
        this.m_monitor.worked(1);
        if (!(node instanceof IParamNodePO)) {
            return true;
        }
        if (this.m_monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IParamNodePO pNode = (IParamNodePO)node;
        ITDManager manager = pNode.getDataManager();
        int i = 0;
        while (i < manager.getDataSetCount()) {
            IDataSetPO row = manager.getDataSet(i);
            int j = 0;
            while (j < row.getColumnCount()) {
                for (String[] ref : TestDataBP.getAllCTDSReferences((String)manager.getDataSet(i).getValueAt(j))) {
                    if (!StringUtils.equals((String)ref[0], (String)this.m_dataSet.getName()) || !StringUtils.equals((String)ref[3], (String)this.m_colStr)) continue;
                    this.addResult(pNode, ref, i, j);
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private void addResult(IParamNodePO pNode, String[] ref, int row, int col) {
        String val;
        boolean exact = false;
        IParamDescriptionPO desc = this.m_dataSet.getParameterForName(ref[1]);
        if (desc != null && StringUtils.equals((String)(val = this.m_dataSet.getDataManager().getCell(this.m_row, desc)), (String)ref[2])) {
            exact = true;
        }
        Image img = exact ? IconConstants.START_OM : IconConstants.STOP_OM;
        BasicSearchResult.SearchResultElement<CTDSReference> result = new BasicSearchResult.SearchResultElement<CTDSReference>(NLS.bind((String)Messages.SearchResultPageElementLabel, (Object[])new Object[]{pNode.getParentNode().getName(), pNode.getName()}), new CTDSReference(pNode, row, col), img, new BasicSearchResult.TestDataCubeExtendedAction());
        if (exact) {
            this.m_exactResults.add(result);
        } else {
            this.m_columnResults.add(result);
        }
    }

    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        this.m_exactResults = new ArrayList<BasicSearchResult.SearchResultElement>();
        this.m_columnResults = new ArrayList<BasicSearchResult.SearchResultElement>();
        TreeTraverser trav = new TreeTraverser((INodePO)GeneralStorage.getInstance().getProject(), (ITreeNodeOperation)this, true, true);
        trav.setTraverseIntoExecs(false);
        trav.setTraverseReused(false);
        System.currentTimeMillis();
        this.m_monitor = null;
        this.m_counter = 0;
        trav.traverse(false);
        this.m_monitor = monitor;
        monitor.beginTask(Messages.SearchingForCTDSRefs, this.m_counter);
        trav.traverse(false);
        monitor.done();
        ArrayList<BasicSearchResult.SearchResultElement> results = new ArrayList<BasicSearchResult.SearchResultElement>();
        results.addAll(this.m_exactResults);
        results.addAll(this.m_columnResults);
        this.setSearchResult(results);
        return Status.OK_STATUS;
    }

    public String getLabel() {
        return "Searching for CTDS reference";
    }

    public void postOperate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
    }

    public static class CTDSReference {
        private IParamNodePO m_node;
        private int m_row;
        private int m_col;

        public CTDSReference(IParamNodePO node, int row, int col) {
            this.m_node = node;
            this.m_row = row;
            this.m_col = col;
        }

        public IParamNodePO getNode() {
            return this.m_node;
        }

        public int getRow() {
            return this.m_row;
        }

        public int getColumn() {
            return this.m_col;
        }
    }
}

