/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.meta;

import org.apache.qpid.jms.meta.JmsAbstractResource;
import org.apache.qpid.jms.meta.JmsResourceVistor;
import org.apache.qpid.jms.meta.JmsSessionId;
import org.apache.qpid.jms.meta.JmsTransactionId;

public final class JmsTransactionInfo
extends JmsAbstractResource
implements Comparable<JmsTransactionInfo> {
    private final JmsSessionId sessionId;
    private final JmsTransactionId transactionId;
    private volatile boolean inDoubt;

    public JmsTransactionInfo(JmsSessionId sessionId, JmsTransactionId transactionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException("Session ID cannot be null");
        }
        if (transactionId == null) {
            throw new IllegalArgumentException("Transaction ID cannot be null");
        }
        this.sessionId = sessionId;
        this.transactionId = transactionId;
    }

    public JmsTransactionInfo copy() {
        return new JmsTransactionInfo(this.sessionId, this.transactionId);
    }

    @Override
    public JmsTransactionId getId() {
        return this.transactionId;
    }

    public JmsSessionId getSessionId() {
        return this.sessionId;
    }

    public boolean isInDoubt() {
        return this.inDoubt;
    }

    public void setInDoubt(boolean inDoubt) {
        this.inDoubt = inDoubt;
    }

    public int hashCode() {
        return this.transactionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JmsTransactionInfo other = (JmsTransactionInfo)obj;
        return this.transactionId.equals(other.transactionId);
    }

    @Override
    public int compareTo(JmsTransactionInfo other) {
        return this.transactionId.compareTo(other.transactionId);
    }

    public String toString() {
        return "JmsTransactionInfo { " + this.transactionId + " }";
    }

    @Override
    public void visit(JmsResourceVistor visitor) throws Exception {
        visitor.processTransactionInfo(this);
    }
}

