/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.mtoolkit.iagent.internal.pmp;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Vector;
import org.tigris.mtoolkit.iagent.internal.pmp.PMPData;

public final class ObjectInfo {
    protected Vector methods;
    protected Object obj;
    protected Class[] interfaces;
    protected Object context;

    protected ObjectInfo(Object obj, Class[] interfaces, Object context) {
        this.obj = obj;
        this.interfaces = interfaces;
        this.context = context;
    }

    protected ObjectInfo(Object obj, Class[] interfaces) {
        this.obj = obj;
        this.interfaces = interfaces;
    }

    public int getMethod(String name, String[] argTypes, Method[] mArr) throws Exception {
        Class[] argtypes = new Class[argTypes.length];
        int i = 0;
        while (i < argTypes.length) {
            argtypes[i] = this.getClass(argTypes[i]);
            ++i;
        }
        Method m = null;
        Exception exc = null;
        if (this.interfaces == null) {
            throw new NoSuchMethodException(name);
        }
        int i2 = 0;
        while (i2 < this.interfaces.length) {
            try {
                m = this.interfaces[i2].getMethod(name, argtypes);
            }
            catch (Exception ex) {
                exc = ex;
            }
            ++i2;
        }
        if (m == null) {
            throw exc;
        }
        mArr[0] = m;
        if (this.methods == null) {
            this.methods = new Vector(2, 5);
        }
        i2 = 0;
        while (i2 < this.methods.size()) {
            if (m.equals(this.methods.elementAt(i2))) {
                return i2 + 1;
            }
            ++i2;
        }
        this.methods.addElement(m);
        return this.methods.size();
    }

    public Vector getMethods() {
        if (this.methods == null) {
            this.methods = new Vector();
        }
        if (this.interfaces != null) {
            int i = 0;
            while (i < this.interfaces.length) {
                Method[] allMethods = this.interfaces[i].getMethods();
                int j = 0;
                while (j < allMethods.length) {
                    if (!this.methods.contains(allMethods[j])) {
                        this.methods.addElement(allMethods[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return this.methods;
    }

    private Class getClass(String name) throws ClassNotFoundException {
        if (name.charAt(0) == '[') {
            if (name.length() == 2) {
                return Class.forName(name);
            }
            String componentType = name.substring(2);
            Class componentClass = this.getClass(componentType);
            return Array.newInstance(componentClass, 0).getClass();
        }
        return name.equals(PMPData.TYPES1[0]) ? Integer.TYPE : (name.equals(PMPData.TYPES1[4]) ? Long.TYPE : (name.equals(PMPData.TYPES1[3]) ? Short.TYPE : (name.equals(PMPData.TYPES1[1]) ? Byte.TYPE : (name.equals(PMPData.TYPES1[2]) ? Character.TYPE : (name.equals(PMPData.TYPES1[5]) ? Float.TYPE : (name.equals(PMPData.TYPES1[6]) ? Double.TYPE : (name.equals(PMPData.TYPES1[8]) ? Void.TYPE : (name.equals(PMPData.TYPES1[7]) ? Boolean.TYPE : (this.obj.getClass().getClassLoader() == null ? Class.forName(name) : this.obj.getClass().getClassLoader().loadClass(name))))))))));
    }

    public void freeInfo() {
        this.methods = null;
        this.obj = null;
        this.context = null;
        this.interfaces = null;
    }
}

