/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.certificates;

import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.certificate.CertificatesService;
import org.eclipse.kura.core.certificates.KeyStoreManagement;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.message.KuraApplicationTopic;
import org.eclipse.kura.message.KuraPayload;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificatesManager
implements CertificatesService {
    private static final Logger s_logger = LoggerFactory.getLogger(CertificatesManager.class);
    private static final String DEFAULT_KEYSTORE = System.getProperty("org.osgi.framework.trust.repositories");
    public static final String APP_ID = "org.eclipse.kura.core.certificates.CertificatesManager";
    private CryptoService cryptoService;

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public void unsetCryptoService(CryptoService cryptoService) {
        this.cryptoService = null;
    }

    protected void activate(ComponentContext componentContext) {
        s_logger.info("Bundle org.eclipse.kura.core.certificates.CertificatesManager has started!");
    }

    protected void deactivate(ComponentContext componentContext) {
        s_logger.info("Bundle org.eclipse.kura.core.certificates.CertificatesManager is deactivating!");
    }

    public Certificate returnCertificate(String alias) throws KuraException {
        try {
            char[] keystorePassword = this.cryptoService.getKeyStorePassword(DEFAULT_KEYSTORE);
            return this.getCertificateFromKeyStore(keystorePassword, alias);
        }
        catch (Exception exception) {
            throw KuraException.internalError((String)"Error retrieving the certificate from the keystore");
        }
    }

    public void storeCertificate(Certificate arg1, String alias) throws KuraException {
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    public Enumeration<String> listBundleCertificatesAliases() {
        return this.listStoredCertificatesAliases();
    }

    public Enumeration<String> listDMCertificatesAliases() {
        return this.listStoredCertificatesAliases();
    }

    public Enumeration<String> listSSLCertificatesAliases() {
        return this.listStoredCertificatesAliases();
    }

    public Enumeration<String> listCACertificatesAliases() {
        return this.listStoredCertificatesAliases();
    }

    public void removeCertificate(String alias) throws KuraException {
        throw new KuraException(KuraErrorCode.OPERATION_NOT_SUPPORTED);
    }

    public boolean verifySignature(KuraApplicationTopic kuraTopic, KuraPayload kuraPayload) {
        return true;
    }

    protected Certificate getCertificateFromKeyStore(char[] keyStorePassword, String alias) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        KeyStore ks = KeyStoreManagement.loadKeyStore(keyStorePassword);
        return ks.getCertificate(alias);
    }

    protected Enumeration<String> getAliasesFromKeyStore(char[] keyStorePassword) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        KeyStore ks = KeyStoreManagement.loadKeyStore(keyStorePassword);
        return ks.aliases();
    }

    private Enumeration<String> listStoredCertificatesAliases() {
        try {
            char[] keystorePassword = this.cryptoService.getKeyStorePassword(DEFAULT_KEYSTORE);
            return this.getAliasesFromKeyStore(keystorePassword);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

