/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.camel.cloud.factory.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.camel.cloud.factory.internal.CamelFactory;
import org.eclipse.kura.camel.component.Configuration;
import org.eclipse.kura.cloud.factory.CloudServiceFactory;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelCloudServiceFactory
implements CloudServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(CamelCloudServiceFactory.class);
    public static final String PID = "org.eclipse.kura.camel.cloud.factory.CamelCloudServiceFactory";
    private ConfigurationService configurationService;

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    protected void add(String pid, Map<String, Object> properties) throws KuraException {
        logger.info("Add: {}", (Object)pid);
        HashMap<String, Object> props = new HashMap<String, Object>();
        String xml = Configuration.asString(properties, (String)"xml");
        if (xml == null || xml.trim().isEmpty()) {
            xml = "<routes xmlns=\"http://camel.apache.org/schema/spring\"></routes>";
        }
        props.put("xml", xml);
        Integer serviceRanking = Configuration.asInteger(properties, (String)"serviceRanking");
        if (serviceRanking != null) {
            props.put("serviceRanking", serviceRanking);
        }
        props.put("cloud.service.pid", pid);
        this.configurationService.createFactoryConfiguration("org.eclipse.kura.camel.cloud.factory.CamelFactory", CamelCloudServiceFactory.fromUserPid(pid), props, true);
    }

    private static String fromUserPid(String pid) {
        Objects.requireNonNull(pid);
        return String.valueOf(pid) + "-CloudFactory";
    }

    private static String fromInternalPid(String pid) {
        Objects.requireNonNull(pid);
        return pid.replaceAll("-CloudFactory$", "");
    }

    public static Set<String> lookupIds() {
        TreeSet<String> ids = new TreeSet<String>();
        try {
            Collection refs = FrameworkUtil.getBundle(CamelCloudServiceFactory.class).getBundleContext().getServiceReferences(CamelFactory.class, null);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    CamelCloudServiceFactory.addService((ServiceReference<CamelFactory>)ref, ids);
                }
            }
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
        return ids;
    }

    private static void addService(ServiceReference<CamelFactory> ref, Set<String> ids) {
        Object kpid = ref.getProperty("kura.service.pid");
        if (kpid instanceof String) {
            ids.add((String)kpid);
        }
    }

    static void delete(ConfigurationService configurationService, String pid) {
        try {
            configurationService.deleteFactoryConfiguration(pid, true);
        }
        catch (KuraException e) {
            logger.warn("Failed to delete: {}", (Object)pid, (Object)e);
        }
    }

    public void createConfiguration(String pid) throws KuraException {
        this.add(pid, Collections.emptyMap());
    }

    public void deleteConfiguration(String pid) throws KuraException {
        CamelCloudServiceFactory.delete(this.configurationService, CamelCloudServiceFactory.fromUserPid(pid));
    }

    public String getFactoryPid() {
        return "org.eclipse.kura.camel.cloud.factory.CamelFactory";
    }

    public List<String> getStackComponentsPids(String pid) throws KuraException {
        return Collections.singletonList(CamelCloudServiceFactory.fromUserPid(pid));
    }

    public Set<String> getManagedCloudServicePids() throws KuraException {
        HashSet<String> result = new HashSet<String>();
        for (ComponentConfiguration cc : this.configurationService.getComponentConfigurations()) {
            if (cc.getDefinition() == null || !"org.eclipse.kura.camel.cloud.factory.CamelFactory".equals(cc.getDefinition().getId())) continue;
            result.add(CamelCloudServiceFactory.fromInternalPid(cc.getPid()));
        }
        return result;
    }
}

