/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet.internal;

import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.libra.facet.internal.WebContextRootSynchonizer;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class LibraFacetPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.libra.facet";
    private static LibraFacetPlugin plugin;
    private ServiceReference<IBundleProjectService> ref;
    private IBundleProjectService service;
    private WebContextRootSynchonizer webContextRootListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.ref = context.getServiceReference(IBundleProjectService.class);
        this.service = (IBundleProjectService)context.getService(this.ref);
        this.webContextRootListener = new WebContextRootSynchonizer();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.webContextRootListener, 1);
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContextRootListener);
        context.ungetService(this.ref);
        plugin = null;
        super.stop(context);
    }

    public static LibraFacetPlugin getDefault() {
        return plugin;
    }

    public IBundleProjectService getBundleProjectService() {
        return this.service;
    }

    public static void logError(String msg) {
        LibraFacetPlugin.logError(msg, null);
    }

    public static void logError(Throwable throwable) {
        LibraFacetPlugin.logError(throwable.getLocalizedMessage(), throwable);
    }

    public static void logError(String msg, Throwable throwable) {
        LibraFacetPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, throwable));
    }

    public static void log(IStatus status) {
        plugin.getLog().log(status);
    }

    public static void logInfo(String msg) {
        LibraFacetPlugin.log((IStatus)new Status(1, PLUGIN_ID, 0, msg, null));
    }
}

