/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.libra.framework.core.IOSGIFrameworkInstance;
import org.eclipse.libra.framework.ui.Messages;
import org.eclipse.libra.framework.ui.internal.SWTUtil;
import org.eclipse.libra.framework.ui.internal.editor.ServerChangedCommand;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;

public class JMXPropertiesEditorSection
extends ServerEditorSection {
    protected Section section;
    protected IOSGIFrameworkInstance frameworkInstance;
    protected PropertyChangeListener listener;
    Button jmxEnabled;
    Text jmxPortText;
    protected boolean updating = false;

    protected void addChangeListeners() {
        this.listener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (JMXPropertiesEditorSection.this.updating) {
                    return;
                }
                JMXPropertiesEditorSection.this.updating = true;
                if ("jmxPort".equals(event.getPropertyName()) || "jmxEnabled".equals(event.getPropertyName())) {
                    JMXPropertiesEditorSection.this.validate();
                }
                JMXPropertiesEditorSection.this.updating = false;
            }
        };
        this.server.addPropertyChangeListener(this.listener);
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        FormToolkit toolkit = this.getFormToolkit(parent.getDisplay());
        this.section = toolkit.createSection(parent, 458);
        this.section.setText(Messages.jmxSection);
        this.section.setDescription(Messages.jmxSectionDescription);
        this.section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)this.section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 5;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(784));
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)composite, "org.eclipse.libra.framework.ui.teig0000");
        whs.setHelp((Control)this.section, "org.eclipse.libra.framework.ui.teig0000");
        toolkit.paintBordersFor(composite);
        this.section.setClient((Control)composite);
        this.jmxEnabled = SWTUtil.createCheckButton(composite, Messages.jmxEnabled, 1);
        this.jmxEnabled.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                JMXPropertiesEditorSection.this.handleEdit();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                JMXPropertiesEditorSection.this.handleEdit();
            }
        });
        Label label = this.createLabel(toolkit, composite, Messages.jmxSection);
        GridData data = new GridData(1, 0x1000000, false, false);
        label.setLayoutData((Object)data);
        this.jmxPortText = SWTUtil.createText(composite, 2052, 1);
        this.jmxPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JMXPropertiesEditorSection.this.handleEdit();
            }
        });
        this.initialize();
    }

    protected Label createLabel(FormToolkit toolkit, Composite parent, String text) {
        Label label = toolkit.createLabel(parent, text);
        label.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        return label;
    }

    public void dispose() {
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        if (this.server != null) {
            this.frameworkInstance = (IOSGIFrameworkInstance)this.server.loadAdapter(IOSGIFrameworkInstance.class, null);
            this.addChangeListeners();
        }
        this.initialize();
    }

    protected void initialize() {
        if (this.frameworkInstance == null) {
            return;
        }
        this.updating = true;
        int port = this.frameworkInstance.getJMXPort();
        boolean enabled = this.frameworkInstance.getJMXEnabled();
        if (this.jmxPortText != null) {
            this.jmxPortText.setText("" + port);
            this.jmxPortText.setEnabled(enabled);
        }
        if (this.jmxEnabled != null) {
            this.jmxEnabled.setSelection(enabled);
        }
        this.updating = false;
        this.validate();
    }

    protected void validate() {
        if (this.frameworkInstance != null && this.jmxEnabled != null && this.jmxPortText != null) {
            boolean en = this.jmxEnabled.getSelection();
            String port = this.jmxPortText.getText();
            if (en) {
                try {
                    Integer.parseInt(port);
                }
                catch (Exception exception) {
                    this.setErrorMessage(Messages.jmxInvalidPort);
                }
            }
        }
        this.setErrorMessage(null);
    }

    void makeDirty() {
        this.execute((IUndoableOperation)new ServerChangedCommand(this.frameworkInstance));
    }

    protected void handleEdit() {
        if (this.frameworkInstance != null && !this.updating) {
            boolean enabledNewValue = this.jmxEnabled.getSelection();
            String portNewValue = this.jmxPortText.getText();
            boolean enabledOldValue = this.frameworkInstance.getJMXEnabled();
            int portOldValue = this.frameworkInstance.getJMXPort();
            try {
                int p = portOldValue;
                if (enabledNewValue && portOldValue != (p = Integer.parseInt(portNewValue))) {
                    this.frameworkInstance.setJMXPort(p);
                }
                this.frameworkInstance.setJMXEnabled(enabledNewValue);
                this.jmxPortText.setEnabled(enabledNewValue);
                if (p != portOldValue || enabledNewValue != enabledOldValue) {
                    this.makeDirty();
                }
            }
            catch (Exception exception) {}
        }
    }
}

