/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.linuxtools.internal.docker.core.ContainerFileProxy;
import org.eclipse.linuxtools.internal.docker.ui.ContainerDirectorySelectionDialog;
import org.eclipse.linuxtools.internal.docker.ui.ContainerFileSystemProvider;
import org.eclipse.linuxtools.internal.docker.ui.IDEFileSystemStructureProvider;
import org.eclipse.linuxtools.internal.docker.ui.MinimizedFileSystemElement;
import org.eclipse.linuxtools.internal.docker.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.docker.ui.wizards.CopyToContainerMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileSystemElement;
import org.eclipse.ui.dialogs.WizardResourceImportPage;
import org.eclipse.ui.ide.dialogs.IElementFilter;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;

public class ContainerCopyToPage
extends WizardResourceImportPage {
    public static final String FILE_SYSTEM_IMPORT_WIZARD_PAGE = "org.eclipse.ui.file_system_import_wizard_page";
    protected Combo sourceNameField;
    protected String pathVariable;
    protected Button sourceBrowseButton;
    protected Button selectTypesButton;
    protected Button selectAllButton;
    protected Button deselectAllButton;
    private boolean entryChanged = false;
    private IDEFileSystemStructureProvider fileSystemStructureProvider = new IDEFileSystemStructureProvider();
    private static final String STORE_SOURCE_NAMES_ID = "WizardFileSystemResourceImportPage1.STORE_SOURCE_NAMES_ID";
    private static final String SELECT_TYPES_TITLE = CopyToContainerMessages.DataTransfer_selectTypes;
    private static final String SELECT_ALL_TITLE = CopyToContainerMessages.DataTransfer_selectAll;
    private static final String DESELECT_ALL_TITLE = CopyToContainerMessages.DataTransfer_deselectAll;
    private static final String SELECT_SOURCE_TITLE = CopyToContainerMessages.ContainerCopyTo_selectSourceTitle;
    private static final String SELECT_SOURCE_MESSAGE = CopyToContainerMessages.ContainerCopyTo_selectSource;
    protected static final String SOURCE_EMPTY_MESSAGE = CopyToContainerMessages.ContainerCopyTo_sourceEmpty;
    protected static final String DESTINATION_EMPTY_MESSAGE = CopyToContainerMessages.ContainerCopyTo_destinationEmpty;
    protected static final String INTO_FOLDER_LABEL = CopyToContainerMessages.ContainerCopyTo_intoFolder;
    protected static final String CONTAINER_DIRECTORY_MSG = CopyToContainerMessages.ContainerCopyTo_containerDirectoryMsg;
    private FileSystemElement root;
    private boolean canBrowseContainer;
    private ContainerFileSystemProvider provider;
    private String containerName;
    private Text containerNameField;
    private List<Object> fileSystemObjects = new ArrayList<Object>();
    private IPath destination;

    public ContainerCopyToPage(FileSystemElement root, ContainerFileSystemProvider provider, String containerName, boolean canBrowseContainer) {
        super("ContainerCopyToPage1", (IStructuredSelection)StructuredSelection.EMPTY);
        this.root = root;
        this.provider = provider;
        this.containerName = containerName;
        this.canBrowseContainer = canBrowseContainer;
        this.setTitle(NLS.bind((String)CopyToContainerMessages.ContainerCopyTo_title, (Object)this.containerName));
        this.setDescription(NLS.bind((String)CopyToContainerMessages.ContainerCopyTo_description, (Object)containerName));
        this.setImageDescriptor(SWTImagesFactory.DESC_WIZARD);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        GridData buttonData = new GridData(768);
        button.setLayoutData((Object)buttonData);
        button.setData((Object)id);
        button.setText(label);
        if (defaultButton) {
            Shell shell = parent.getShell();
            if (shell != null) {
                shell.setDefaultButton(button);
            }
            button.setFocus();
        }
        return button;
    }

    protected final void createButtonsGroup(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(parent.getFont());
        GridData buttonData = new GridData(4, 4, true, false);
        buttonComposite.setLayoutData((Object)buttonData);
        this.selectTypesButton = this.createButton(buttonComposite, 20, SELECT_TYPES_TITLE, false);
        SelectionListener listener = SelectionListener.widgetSelectedAdapter(e -> this.handleTypesEditButtonPressed());
        this.selectTypesButton.addSelectionListener(listener);
        this.setButtonLayoutData(this.selectTypesButton);
        this.selectAllButton = this.createButton(buttonComposite, 18, SELECT_ALL_TITLE, false);
        listener = SelectionListener.widgetSelectedAdapter(e -> {
            this.setAllSelections(true);
            this.updateWidgetEnablements();
        });
        this.selectAllButton.addSelectionListener(listener);
        this.setButtonLayoutData(this.selectAllButton);
        this.deselectAllButton = this.createButton(buttonComposite, 19, DESELECT_ALL_TITLE, false);
        listener = SelectionListener.widgetSelectedAdapter(e -> {
            this.setAllSelections(false);
            this.updateWidgetEnablements();
        });
        this.deselectAllButton.addSelectionListener(listener);
        this.setButtonLayoutData(this.deselectAllButton);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.validateSourceGroup();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), FILE_SYSTEM_IMPORT_WIZARD_PAGE);
    }

    protected void createOptionsGroup(Composite parent) {
    }

    protected void createDestinationGroup(Composite parent) {
        if (this.canBrowseContainer) {
            super.createDestinationGroup(parent);
        } else {
            Composite containerGroup = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            containerGroup.setLayout((Layout)layout);
            containerGroup.setLayoutData((Object)new GridData(768));
            containerGroup.setFont(parent.getFont());
            Label resourcesLabel = new Label(containerGroup, 0);
            resourcesLabel.setText(INTO_FOLDER_LABEL);
            resourcesLabel.setFont(parent.getFont());
            this.containerNameField = new Text(containerGroup, 2052);
            BidiUtils.applyBidiProcessing((Text)this.containerNameField, (String)"file");
            this.containerNameField.addListener(24, (Listener)this);
            GridData data = new GridData(768);
            data.widthHint = 250;
            this.containerNameField.setLayoutData((Object)data);
            this.containerNameField.setFont(parent.getFont());
            Label dummyLabel = new Label(containerGroup, 0);
            dummyLabel.setText(" ");
        }
    }

    protected void createRootDirectoryGroup(Composite parent) {
        Composite sourceContainerGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        sourceContainerGroup.setLayout((Layout)layout);
        sourceContainerGroup.setFont(parent.getFont());
        sourceContainerGroup.setLayoutData((Object)new GridData(768));
        Label groupLabel = new Label(sourceContainerGroup, 0);
        groupLabel.setText(this.getSourceLabel());
        groupLabel.setFont(parent.getFont());
        this.sourceNameField = new Combo(sourceContainerGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.sourceNameField.setLayoutData((Object)data);
        this.sourceNameField.setFont(parent.getFont());
        BidiUtils.applyBidiProcessing((Combo)this.sourceNameField, (String)"file");
        this.sourceNameField.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateFromSourceField()));
        this.sourceNameField.addKeyListener(KeyListener.keyPressedAdapter(e -> {
            if (e.character == '\r') {
                this.entryChanged = false;
                this.updateFromSourceField();
            }
        }));
        this.sourceNameField.addModifyListener(e -> {
            this.entryChanged = true;
        });
        this.sourceNameField.addFocusListener(FocusListener.focusLostAdapter(e -> {
            if (this.entryChanged) {
                this.entryChanged = false;
                this.updateFromSourceField();
            }
        }));
        this.sourceBrowseButton = new Button(sourceContainerGroup, 8);
        this.sourceBrowseButton.setText(CopyToContainerMessages.DataTransfer_browse);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceBrowseButton.setLayoutData((Object)new GridData(256));
        this.sourceBrowseButton.setFont(parent.getFont());
        this.setButtonLayoutData(this.sourceBrowseButton);
    }

    private void updateFromSourceField() {
        this.setSourceName(this.sourceNameField.getText());
        this.updateWidgetEnablements();
        this.fileSystemStructureProvider.clearVisitedDirs();
        this.selectionGroup.setFocus();
    }

    protected MinimizedFileSystemElement createRootElement(Object fileSystemObject, IImportStructureProvider provider) {
        boolean isContainer = provider.isFolder(fileSystemObject);
        String elementLabel = provider.getLabel(fileSystemObject);
        MinimizedFileSystemElement dummyParent = new MinimizedFileSystemElement("", null, true);
        dummyParent.setPopulated();
        MinimizedFileSystemElement result = new MinimizedFileSystemElement(elementLabel, dummyParent, isContainer);
        result.setFileSystemObject(fileSystemObject);
        result.getFiles(provider);
        return dummyParent;
    }

    protected void createSourceGroup(Composite parent) {
        this.createRootDirectoryGroup(parent);
        this.createFileSelectionGroup(parent);
        this.createButtonsGroup(parent);
    }

    protected void enableButtonGroup(boolean enable) {
        this.selectTypesButton.setEnabled(enable);
        this.selectAllButton.setEnabled(enable);
        this.deselectAllButton.setEnabled(enable);
    }

    protected boolean ensureSourceIsValid() {
        if (new File(this.getSourceDirectoryName()).isDirectory()) {
            return true;
        }
        this.setErrorMessage(CopyToContainerMessages.ContainerCopyTo_invalidSource);
        return false;
    }

    public boolean finish() {
        if (!this.ensureSourceIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        Iterator resourcesEnum = this.selectionGroup.getAllWhiteCheckedItems().iterator();
        while (resourcesEnum.hasNext()) {
            this.fileSystemObjects.add(((FileSystemElement)resourcesEnum.next()).getFileSystemObject());
        }
        this.destination = this.getResourcePath();
        if (this.fileSystemObjects.size() > 0 && !this.destination.isEmpty()) {
            return true;
        }
        MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)CopyToContainerMessages.DataTransfer_information, (String)CopyToContainerMessages.ContainerCopyTo_noneSelected);
        return false;
    }

    protected IPath getResourcePath() {
        if (this.canBrowseContainer) {
            return super.getResourcePath();
        }
        return new Path(this.containerNameField.getText());
    }

    public IPath getDestination() {
        return this.destination;
    }

    public List<Object> getFilesToCopy() {
        return this.fileSystemObjects;
    }

    protected ITreeContentProvider getFileProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    return element.getFiles(ContainerCopyToPage.this.fileSystemStructureProvider).getChildren((Object)element);
                }
                return new Object[0];
            }
        };
    }

    protected MinimizedFileSystemElement getFileSystemTree() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            return null;
        }
        return this.selectFiles(sourceDirectory, this.fileSystemStructureProvider);
    }

    protected ITreeContentProvider getFolderProvider() {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    return element.getFolders(ContainerCopyToPage.this.fileSystemStructureProvider).getChildren((Object)element);
                }
                return new Object[0];
            }

            public boolean hasChildren(Object o) {
                if (o instanceof MinimizedFileSystemElement) {
                    MinimizedFileSystemElement element = (MinimizedFileSystemElement)((Object)o);
                    if (element.isPopulated()) {
                        return this.getChildren((Object)element).length > 0;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    protected File getSourceDirectory() {
        return this.getSourceDirectory(this.sourceNameField.getText());
    }

    private File getSourceDirectory(String path) {
        File sourceDirectory = new File(this.getSourceDirectoryName(path));
        if (!sourceDirectory.exists() || !sourceDirectory.isDirectory()) {
            return null;
        }
        return sourceDirectory;
    }

    private String getSourceDirectoryName() {
        return this.getSourceDirectoryName(this.sourceNameField.getText());
    }

    private String getSourceDirectoryName(String sourceName) {
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        return result.toOSString();
    }

    protected String getSourceLabel() {
        return CopyToContainerMessages.ContainerCopyTo_fromDirectory;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.sourceBrowseButton) {
            this.handleSourceBrowseButtonPressed();
        }
        super.handleEvent(event);
    }

    protected void handleSourceBrowseButtonPressed() {
        String currentSource = this.sourceNameField.getText();
        DirectoryDialog dialog = new DirectoryDialog(this.sourceNameField.getShell(), 0x10002000);
        dialog.setText(SELECT_SOURCE_TITLE);
        dialog.setMessage(SELECT_SOURCE_MESSAGE);
        dialog.setFilterPath(this.getSourceDirectoryName(currentSource));
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            if (this.getSourceDirectory(selectedDirectory) == null || selectedDirectory.equals(currentSource)) {
                return;
            }
            this.setErrorMessage(null);
            this.setSourceName(selectedDirectory);
            this.selectionGroup.setFocus();
        }
    }

    protected void handleTypesEditButtonPressed() {
        super.handleTypesEditButtonPressed();
    }

    protected void handleContainerBrowseButtonPressed() {
        ContainerDirectorySelectionDialog dialog = new ContainerDirectorySelectionDialog(this.sourceNameField.getShell(), this.root, this.provider, NLS.bind((String)CONTAINER_DIRECTORY_MSG, (Object)this.containerName));
        if (dialog.open() == 0) {
            Object[] result = dialog.getResult();
            ContainerFileProxy proxy = (ContainerFileProxy)result[0];
            this.setErrorMessage(null);
            this.setContainerFieldValue(proxy.getFullPath());
            this.selectionGroup.setFocus();
        }
        this.updateWidgetEnablements();
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestination();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    private boolean validateDestination() {
        IPath containerPath = this.getResourcePath();
        if (containerPath.isEmpty()) {
            this.setErrorMessage(DESTINATION_EMPTY_MESSAGE);
            return false;
        }
        return true;
    }

    protected boolean isExportableExtension(String extension) {
        if (this.selectedTypes == null) {
            return true;
        }
        Iterator itr = this.selectedTypes.iterator();
        while (itr.hasNext()) {
            if (!extension.equalsIgnoreCase((String)itr.next())) continue;
            return true;
        }
        return false;
    }

    protected void resetSelection() {
        MinimizedFileSystemElement currentRoot = this.getFileSystemTree();
        this.selectionGroup.setRoot((Object)currentRoot);
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                return;
            }
            for (int i = 0; i < sourceNames.length; ++i) {
                this.sourceNameField.add(sourceNames[i]);
            }
            this.updateWidgetEnablements();
        }
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_SOURCE_NAMES_ID);
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = this.addToHistory(sourceNames, this.getSourceDirectoryName());
            settings.put(STORE_SOURCE_NAMES_ID, sourceNames);
        }
    }

    protected MinimizedFileSystemElement selectFiles(Object rootFileSystemObject, IImportStructureProvider structureProvider) {
        MinimizedFileSystemElement[] results = new MinimizedFileSystemElement[1];
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), () -> {
            results[0] = this.createRootElement(rootFileSystemObject, structureProvider);
        });
        return results[0];
    }

    protected void setAllSelections(boolean value) {
        super.setAllSelections(value);
    }

    protected void setSourceName(String path) {
        if (path.length() > 0) {
            String[] currentItems = this.sourceNameField.getItems();
            int selectionIndex = -1;
            for (int i = 0; i < currentItems.length; ++i) {
                if (!currentItems[i].equals(path)) continue;
                selectionIndex = i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.sourceNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.sourceNameField.select(selectionIndex);
            this.resetSelection();
        }
    }

    protected void setupSelectionsBasedOnSelectedTypes() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getContainer().getShell());
        final Hashtable selectionMap = new Hashtable();
        IElementFilter filter = new IElementFilter(){

            public void filterElements(Collection files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                Iterator filesList = files.iterator();
                while (filesList.hasNext()) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(filesList.next());
                }
            }

            public void filterElements(Object[] files, IProgressMonitor monitor) throws InterruptedException {
                if (files == null) {
                    throw new InterruptedException();
                }
                for (int i = 0; i < files.length; ++i) {
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    this.checkFile(files[i]);
                }
            }

            private void checkFile(Object fileElement) {
                MinimizedFileSystemElement file = (MinimizedFileSystemElement)((Object)fileElement);
                if (ContainerCopyToPage.this.isExportableExtension(file.getFileNameExtension())) {
                    List<MinimizedFileSystemElement> elements = new ArrayList<MinimizedFileSystemElement>();
                    FileSystemElement parent = file.getParent();
                    if (selectionMap.containsKey(parent)) {
                        elements = (List)selectionMap.get(parent);
                    }
                    elements.add(file);
                    selectionMap.put(parent, elements);
                }
            }
        };
        IRunnableWithProgress runnable = monitor -> {
            monitor.beginTask(CopyToContainerMessages.ImportPage_filterSelections, -1);
            this.getSelectedResources(filter, monitor);
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException exception) {
            return;
        }
        catch (InterruptedException exception) {
            return;
        }
        this.getShell().update();
        if (selectionMap != null) {
            this.updateSelections(selectionMap);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.resetSelection();
        if (visible) {
            this.selectionGroup.setFocus();
            this.sourceNameField.setFocus();
        }
    }

    protected void updateSelections(Map map) {
        super.updateSelections(map);
    }

    protected void updateWidgetEnablements() {
        super.updateWidgetEnablements();
        this.enableButtonGroup(this.ensureSourceIsValid());
    }

    protected boolean validateSourceGroup() {
        File sourceDirectory = this.getSourceDirectory();
        if (sourceDirectory == null) {
            this.setErrorMessage(SOURCE_EMPTY_MESSAGE);
            this.enableButtonGroup(false);
            return false;
        }
        if (this.sourceConflictsWithDestination((IPath)new Path(sourceDirectory.getPath()))) {
            this.setMessage(null);
            this.setErrorMessage(this.getSourceConflictMessage());
            this.enableButtonGroup(false);
            return false;
        }
        List resourcesToExport = this.selectionGroup.getAllWhiteCheckedItems();
        if (resourcesToExport.size() == 0) {
            this.setMessage(null);
            this.setErrorMessage(CopyToContainerMessages.ContainerCopyTo_noneSelected);
            return false;
        }
        this.enableButtonGroup(true);
        this.setErrorMessage(null);
        return true;
    }

    protected boolean sourceConflictsWithDestination(IPath sourcePath) {
        return false;
    }
}

