/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.completion;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.operations.completion.LSContentAssistProcessor;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ContextInformationTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;
    private LSContentAssistProcessor contentAssistProcessor;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("ContextInformationTest" + System.currentTimeMillis());
        this.contentAssistProcessor = new LSContentAssistProcessor();
    }

    @Test
    public void testNoContextInformation() throws CoreException, InvocationTargetException {
        MockLanguageServer.INSTANCE.setSignatureHelp(new SignatureHelp());
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IContextInformation[] infos = this.contentAssistProcessor.computeContextInformation(viewer, 0);
        Assert.assertEquals((long)0L, (long)infos.length);
    }

    @Test
    public void testContextInformationNoParameters() throws CoreException, InvocationTargetException {
        SignatureHelp signatureHelp = new SignatureHelp();
        SignatureInformation information = new SignatureInformation("label", "documentation", Collections.emptyList());
        signatureHelp.setSignatures(Collections.singletonList(information));
        MockLanguageServer.INSTANCE.setSignatureHelp(signatureHelp);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "method()");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        IContextInformation[] infos = this.contentAssistProcessor.computeContextInformation(viewer, 0);
        Assert.assertEquals((long)1L, (long)infos.length);
        String expected = information.getLabel() + '\n' + LSPEclipseUtils.getDocString((Either)information.getDocumentation());
        Assert.assertEquals((Object)expected, (Object)infos[0].getInformationDisplayString());
    }

    @Test
    public void testTriggerChars() throws CoreException, InvocationTargetException {
        HashSet<String> triggers = new HashSet<String>();
        triggers.add("a");
        triggers.add("b");
        MockLanguageServer.INSTANCE.setContextInformationTriggerChars(triggers);
        String content = "First";
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, content));
        Assert.assertArrayEquals((char[])new char[]{'a', 'b'}, (char[])this.contentAssistProcessor.getContextInformationAutoActivationCharacters());
    }

    @Test
    public void testTriggerCharsNullList() throws CoreException, InvocationTargetException {
        MockLanguageServer.INSTANCE.setContextInformationTriggerChars(null);
        TestUtils.openTextViewer(TestUtils.createUniqueTestFile(this.project, "First"));
        Assert.assertArrayEquals((char[])new char[0], (char[])this.contentAssistProcessor.getContextInformationAutoActivationCharacters());
    }
}

