/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.linkedediting;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.tests.util.DisplayHelper;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class LinkedEditingTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("LinkedEditingTest" + System.currentTimeMillis());
    }

    @Test
    public void testLinkedEditingHighlight() throws CoreException, InvocationTargetException {
        Annotation annotation;
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(new Range(new Position(1, 3), new Position(1, 7)));
        ranges.add(new Range(new Position(3, 4), new Position(3, 8)));
        LinkedEditingRanges linkkedEditingRanges = new LinkedEditingRanges(ranges);
        MockLanguageServer.INSTANCE.setLinkedEditingRanges(linkkedEditingRanges);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "<html>\n  <body>\n    a body text\n  </body>\n</html>");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        viewer.getTextWidget().setCaretOffset(11);
        if (!(viewer instanceof ISourceViewer)) {
            Assert.fail();
        }
        final ISourceViewer sourceViewer = (ISourceViewer)viewer;
        viewer.getTextWidget().setSelection(11);
        HashMap<org.eclipse.jface.text.Position, Annotation> annotations = new HashMap<org.eclipse.jface.text.Position, Annotation>();
        new DisplayHelper(){

            protected boolean condition() {
                Iterator iterator = sourceViewer.getAnnotationModel().getAnnotationIterator();
                while (iterator.hasNext()) {
                    Annotation annotation = (Annotation)iterator.next();
                    if (!"org.eclipse.lsp4e.linkedediting".equals(annotation.getType())) continue;
                    return true;
                }
                return false;
            }
        }.waitForCondition(Display.getCurrent(), 3000L);
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        Iterator iterator = model.getAnnotationIterator();
        while (iterator.hasNext()) {
            annotation = (Annotation)iterator.next();
            annotations.put(model.getPosition(annotation), annotation);
        }
        annotation = (Annotation)annotations.get(new org.eclipse.jface.text.Position(10, 4));
        Assert.assertNotNull((Object)annotation);
        Assert.assertEquals((Object)"org.eclipse.lsp4e.linkedediting", (Object)annotation.getType());
        Assert.assertTrue((boolean)viewer.isEditable());
        try {
            CompletableFuture didChangeExpectation = new CompletableFuture();
            MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
            String text = "w";
            String expectedChangeText = viewer.getDocument().get().replace("body>", "wbody>");
            viewer.getTextWidget().replaceTextRange(10, 0, text);
            DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)lastChange.getContentChanges());
            Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
            TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
            Assert.assertEquals((Object)expectedChangeText, (Object)change0.getText());
            Assert.assertEquals((Object)expectedChangeText, (Object)viewer.getDocument().get());
            didChangeExpectation = new CompletableFuture();
            MockLanguageServer.INSTANCE.setDidChangeCallback(didChangeExpectation);
            expectedChangeText = viewer.getDocument().get().replace("body>", "wbody>");
            viewer.getTextWidget().replaceTextRange(11, 0, text);
            lastChange = (DidChangeTextDocumentParams)didChangeExpectation.get(1000L, TimeUnit.MILLISECONDS);
            Assert.assertNotNull((Object)lastChange.getContentChanges());
            Assert.assertEquals((long)1L, (long)lastChange.getContentChanges().size());
            change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
            Assert.assertEquals((Object)expectedChangeText, (Object)change0.getText());
            Assert.assertEquals((Object)expectedChangeText, (Object)viewer.getDocument().get());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }
}

