/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.definition;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.operations.declaration.LSBasedHyperlink;
import org.eclipse.lsp4e.operations.declaration.OpenDeclarationHyperlinkDetector;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DefinitionTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;
    private OpenDeclarationHyperlinkDetector hyperlinkDetector;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DefinitionTest" + System.currentTimeMillis());
        this.hyperlinkDetector = new OpenDeclarationHyperlinkDetector();
    }

    @Test
    public void testDefinitionOneLocation() throws Exception {
        Location location = new Location("file://test", new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setDefinition(Collections.singletonList(location));
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((long)1L, (long)hyperlinks.length);
    }

    @Test
    public void testDefinitionAndTypeDefinition() throws Exception {
        Range definitionRange = new Range(new Position(0, 0), new Position(0, 1));
        MockLanguageServer.INSTANCE.setDefinition(Collections.singletonList(new Location("file://testDefinition", definitionRange)));
        Range typeDefinitionRange = new Range(new Position(0, 2), new Position(0, 3));
        MockLanguageServer.INSTANCE.setTypeDefinitions(Collections.singletonList(new LocationLink("file://testTypeDefinition", typeDefinitionRange, typeDefinitionRange)));
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((long)2L, (long)hyperlinks.length);
        Set uris = Arrays.stream(hyperlinks).map(LSBasedHyperlink.class::cast).map(LSBasedHyperlink::getLocation).map(location -> {
            if (location.isLeft()) {
                return ((Location)location.getLeft()).getUri();
            }
            return ((LocationLink)location.getRight()).getTargetUri();
        }).collect(Collectors.toSet());
        Assert.assertTrue((boolean)uris.contains("file://testDefinition"));
        Assert.assertTrue((boolean)uris.contains("file://testTypeDefinition"));
    }

    @Test
    public void testDefinitionOneLocationExternalFile() throws Exception {
        Location location = new Location("file://test", new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setDefinition(Collections.singletonList(location));
        File file = TestUtils.createTempFile("testDocumentLinkExternalFile", ".lspt");
        ITextEditor editor = (ITextEditor)IDE.openInternalEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        ITextViewer viewer = TestUtils.getTextViewer((IEditorPart)editor);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(0, 0), true);
        Assert.assertEquals((long)1L, (long)hyperlinks.length);
    }

    @Test
    public void testDefinitionManyLocation() throws Exception {
        ArrayList<Location> locations = new ArrayList<Location>();
        locations.add(new Location("file://test0", new Range(new Position(0, 0), new Position(0, 10))));
        locations.add(new Location("file://test1", new Range(new Position(1, 0), new Position(1, 10))));
        locations.add(new Location("file://test2", new Range(new Position(2, 0), new Position(2, 10))));
        MockLanguageServer.INSTANCE.setDefinition(locations);
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((long)3L, (long)hyperlinks.length);
    }

    @Test
    public void testDefinitionNoLocations() throws Exception {
        MockLanguageServer.INSTANCE.setDefinition(null);
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((Object)true, (Object)(hyperlinks == null ? 1 : 0));
    }

    @Test
    public void testDefinitionEmptyLocations() throws Exception {
        MockLanguageServer.INSTANCE.setDefinition(Collections.emptyList());
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        Assert.assertEquals((Object)true, (Object)(hyperlinks == null ? 1 : 0));
    }

    @Test
    public void testReturnsPromptly() throws Exception {
        Location location = new Location("file://test", new Range(new Position(0, 0), new Position(0, 10)));
        MockLanguageServer.INSTANCE.setDefinition(Collections.singletonList(location));
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        long duration = System.currentTimeMillis();
        this.hyperlinkDetector.detectHyperlinks(viewer, (IRegion)new Region(1, 0), true);
        duration = System.currentTimeMillis() - duration;
        Assert.assertTrue((duration < 500L ? 1 : 0) != 0);
    }
}

