/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.documentLink;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.operations.documentLink.DocumentLinkDetector;
import org.eclipse.lsp4e.test.AllCleanRule;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class DocumentLinkTest {
    @Rule
    public AllCleanRule clear = new AllCleanRule();
    private IProject project;
    private DocumentLinkDetector documentLinkDetector;

    @Before
    public void setUp() throws CoreException {
        this.project = TestUtils.createProject("DocumentLinkTest" + System.currentTimeMillis());
        this.documentLinkDetector = new DocumentLinkDetector();
    }

    @Test
    public void testDocumentLinkNoResults() throws Exception {
        IFile file = TestUtils.createUniqueTestFile(this.project, "Example Text");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Object[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(0, 0), true);
        Assert.assertArrayEquals(null, (Object[])hyperlinks);
    }

    @Test
    public void testDocumentLink() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://test0"));
        MockLanguageServer.INSTANCE.setDocumentLinks(links);
        IFile file = TestUtils.createUniqueTestFile(this.project, "not_link <link>");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        IHyperlink[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(13, 0), true);
        Assert.assertEquals((long)1L, (long)hyperlinks.length);
        Assert.assertEquals((Object)"file://test0", (Object)hyperlinks[0].getHyperlinkText());
    }

    @Test
    public void testDocumentLinkExternalFile() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://test0"));
        MockLanguageServer.INSTANCE.setDocumentLinks(links);
        File file = TestUtils.createTempFile("testDocumentLinkExternalFile", ".lspt");
        ITextEditor editor = (ITextEditor)IDE.openInternalEditorOnFileStore((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFileStore)EFS.getStore((URI)file.toURI()));
        ITextViewer viewer = TestUtils.getTextViewer((IEditorPart)editor);
        IHyperlink[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(13, 0), true);
        Assert.assertEquals((long)1L, (long)hyperlinks.length);
        Assert.assertEquals((Object)"file://test0", (Object)hyperlinks[0].getHyperlinkText());
    }

    @Test
    public void testDocumentLinkWrongRegion() throws Exception {
        ArrayList<DocumentLink> links = new ArrayList<DocumentLink>();
        links.add(new DocumentLink(new Range(new Position(0, 9), new Position(0, 15)), "file://test0"));
        MockLanguageServer.INSTANCE.setDocumentLinks(links);
        IFile file = TestUtils.createUniqueTestFile(this.project, "not_link <link>");
        ITextViewer viewer = TestUtils.openTextViewer(file);
        Object[] hyperlinks = this.documentLinkDetector.detectHyperlinks(viewer, (IRegion)new Region(0, 0), true);
        Assert.assertArrayEquals(null, (Object[])hyperlinks);
    }
}

