/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public class LanguageServersView
extends ViewPart {
    public static final String ID = "org.eclipse.lsp4e.ui.LanguageServersView";
    private static final String EMPTY = "";
    private static final String NOT_AVAILABLE = "n/a";
    private TableViewer viewer;
    private Job viewerRefreshJob;
    private final Map<LanguageServerWrapper, ToolBar> actionButtons = new HashMap<LanguageServerWrapper, ToolBar>();
    private final List<ColumnLabelProvider> columnLabelProviders = new ArrayList<ColumnLabelProvider>();
    private int tableSortColumn = 1;
    private int tableSortDirection = 1;
    private final ViewerComparator tableSorter = new ViewerComparator(){

        private int compare(int columnIndex, @Nullable Object e1, @Nullable Object e2) {
            ColumnLabelProvider labelProvider = LanguageServersView.this.columnLabelProviders.get(columnIndex);
            return this.getComparator().compare(Objects.toString(labelProvider.getText(e1), LanguageServersView.EMPTY), Objects.toString(labelProvider.getText(e2), LanguageServersView.EMPTY));
        }

        public int compare(Viewer viewer, @Nullable Object e1, @Nullable Object e2) {
            int sortResult = this.compare(LanguageServersView.this.tableSortColumn, e1, e2);
            if (sortResult == 0 && LanguageServersView.this.tableSortColumn != 1) {
                sortResult = this.compare(1, e1, e2);
            }
            return sortResult * LanguageServersView.this.tableSortDirection;
        }
    };

    private void createColumn(String name, int width, ColumnLabelProvider labelProvider) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.viewer, 0);
        final TableColumn tableColumn = viewerColumn.getColumn();
        tableColumn.setText(name);
        tableColumn.setWidth(width);
        tableColumn.setResizable(true);
        final int columnIndex = this.columnLabelProviders.size();
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                if (columnIndex == 0) {
                    return;
                }
                if (LanguageServersView.this.tableSortColumn == columnIndex) {
                    LanguageServersView.this.tableSortDirection *= -1;
                }
                LanguageServersView.this.tableSortColumn = columnIndex;
                Table table = LanguageServersView.this.viewer.getTable();
                table.setSortDirection(LanguageServersView.this.tableSortDirection == 1 ? 1024 : 128);
                table.setSortColumn(tableColumn);
                LanguageServersView.this.viewer.refresh();
            }
        });
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        this.columnLabelProviders.add(labelProvider);
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 68352);
        this.viewer.setComparator(this.tableSorter);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.createColumn(EMPTY, 26, new ColumnLabelProvider(){

            public void update(ViewerCell cell) {
                final LanguageServerWrapper lsWrapper = (LanguageServerWrapper)cell.getElement();
                TableItem item = (TableItem)cell.getItem();
                ToolBar buttons = LanguageServersView.this.actionButtons.computeIfAbsent(lsWrapper, unused -> {
                    ToolBar toolBar = new ToolBar((Composite)cell.getViewerRow().getControl(), 0x800000);
                    toolBar.setBackground(cell.getBackground());
                    ToolItem terminateButton = new ToolItem(toolBar, 8);
                    terminateButton.setImage(LSPImages.getImage("IMG_TERMINATE_CO"));
                    terminateButton.setToolTipText("Terminate this language server");
                    terminateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent ev) {
                            lsWrapper.stop();
                            LanguageServersView.this.updateViewerInput();
                        }
                    });
                    return toolBar;
                });
                TableEditor editor = new TableEditor(item.getParent());
                editor.setEditor((Control)buttons, item, cell.getColumnIndex());
                editor.grabHorizontal = true;
                editor.grabVertical = true;
                editor.layout();
            }
        });
        this.createColumn("Initial Project", 150, new ColumnLabelProvider(){

            public String getText(Object element) {
                LanguageServerWrapper lsWrapper = (LanguageServerWrapper)element;
                IProject p = lsWrapper.initialProject;
                return p == null ? LanguageServersView.NOT_AVAILABLE : p.getName();
            }
        });
        this.createColumn("Name", 150, new ColumnLabelProvider(){

            public String getText(Object element) {
                LanguageServerWrapper lsWrapper = (LanguageServerWrapper)element;
                return lsWrapper.serverDefinition.label;
            }
        });
        this.createColumn("Executable", 100, new ColumnLabelProvider(){

            public String getText(Object element) {
                String exe;
                ProcessHandle ph = ((LanguageServerWrapper)element).getProcessHandle();
                String string = exe = ph == null ? null : (String)ph.info().command().orElse(null);
                if (exe == null) {
                    return LanguageServersView.NOT_AVAILABLE;
                }
                int backslash = exe.lastIndexOf(92);
                int slash = exe.lastIndexOf(47);
                int lastDirSep = Math.max(slash, backslash);
                return exe.substring(lastDirSep + 1);
            }
        });
        this.createColumn("PID", 50, new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessHandle ph = ((LanguageServerWrapper)element).getProcessHandle();
                if (ph == null) {
                    return LanguageServersView.NOT_AVAILABLE;
                }
                try {
                    return Long.toString(ph.pid());
                }
                catch (UnsupportedOperationException ex) {
                    return LanguageServersView.NOT_AVAILABLE;
                }
            }
        });
        this.createColumn("Command Line", 400, new ColumnLabelProvider(){

            public String getText(Object element) {
                ProcessHandle ph = ((LanguageServerWrapper)element).getProcessHandle();
                if (ph == null) {
                    return LanguageServersView.NOT_AVAILABLE;
                }
                ProcessHandle.Info pi = ph.info();
                return pi.commandLine().orElse(pi.command().orElse(LanguageServersView.NOT_AVAILABLE));
            }
        });
        this.createColumn("ID", 150, new ColumnLabelProvider(){

            public String getText(Object element) {
                LanguageServerWrapper lsWrapper = (LanguageServerWrapper)element;
                return lsWrapper.serverDefinition.id;
            }
        });
        table.setSortDirection(this.tableSortDirection == 1 ? 1024 : 128);
        table.setSortColumn(table.getColumn(this.tableSortColumn));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.scheduleRefreshJob();
    }

    public void dispose() {
        Job viewerRefreshJob = this.viewerRefreshJob;
        if (viewerRefreshJob != null) {
            viewerRefreshJob.cancel();
        }
        super.dispose();
    }

    private void scheduleRefreshJob() {
        this.viewerRefreshJob = new Job("Refresh Language Server Processes view"){

            protected IStatus run(IProgressMonitor monitor) {
                if (LanguageServersView.this.getSite().getPage().isPartVisible((IWorkbenchPart)LanguageServersView.this)) {
                    LanguageServersView.this.updateViewerInput();
                }
                this.schedule(2000L);
                return Status.OK_STATUS;
            }
        };
        this.viewerRefreshJob.setPriority(50);
        this.viewerRefreshJob.setSystem(true);
        this.viewerRefreshJob.schedule();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void updateViewerInput() {
        Object[] newElements;
        Object[] currentElements = (Object[])this.viewer.getInput();
        if (!Arrays.equals(currentElements, newElements = LanguageServiceAccessor.getStartedWrappers(null, capability -> true, true).toArray())) {
            UI.getDisplay().execute(() -> {
                this.actionButtons.values().forEach(Widget::dispose);
                this.actionButtons.clear();
                this.viewer.setInput((Object)newElements);
            });
        }
    }
}

