/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.tests.mock;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.tests.mock.MockLanguageServerMultiRootFolders;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class MockConnectionProviderMultiRootFolders
implements StreamConnectionProvider {
    private static final Logger LOG = Logger.getLogger(MockConnectionProviderMultiRootFolders.class.getName());
    static ExecutorService sharedExecutor = new ThreadPoolExecutor(0, Runtime.getRuntime().availableProcessors(), 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("mock-connection-provider-%d").build());
    private static AtomicInteger startCount = new AtomicInteger(0);
    private static AtomicInteger stopCount = new AtomicInteger(0);
    private InputStream clientInputStream;
    private OutputStream clientOutputStream;
    private InputStream errorStream;
    private Collection<Closeable> streams = new ArrayList<Closeable>(4);
    private Future<Void> launcherFuture;

    public static void resetCounts() {
        startCount.set(0);
        stopCount.set(0);
    }

    public static int getStartCount() {
        return startCount.get();
    }

    public static int getStopCount() {
        return stopCount.get();
    }

    public void start() throws IOException {
        try {
            Pipe serverOutputToClientInput = Pipe.open();
            Pipe clientOutputToServerInput = Pipe.open();
            this.errorStream = InputStream.nullInputStream();
            InputStream serverInputStream = Channels.newInputStream(clientOutputToServerInput.source());
            OutputStream serverOutputStream = Channels.newOutputStream(serverOutputToClientInput.sink());
            Launcher launcher = LSPLauncher.createServerLauncher((LanguageServer)MockLanguageServerMultiRootFolders.INSTANCE, (InputStream)serverInputStream, (OutputStream)serverOutputStream, (ExecutorService)sharedExecutor, c -> c);
            this.clientInputStream = Channels.newInputStream(serverOutputToClientInput.source());
            this.clientOutputStream = Channels.newOutputStream(clientOutputToServerInput.sink());
            this.launcherFuture = launcher.startListening();
            MockLanguageServer.INSTANCE.addRemoteProxy((LanguageClient)launcher.getRemoteProxy());
            this.streams.add(this.clientInputStream);
            this.streams.add(this.clientOutputStream);
            this.streams.add(serverInputStream);
            this.streams.add(serverOutputStream);
            this.streams.add(this.errorStream);
            startCount.incrementAndGet();
        }
        catch (Exception x) {
            LOG.log(Level.SEVERE, "MockConnectionProvider#start", x);
        }
    }

    public InputStream getInputStream() {
        return this.clientInputStream;
    }

    public OutputStream getOutputStream() {
        return this.clientOutputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    public void stop() {
        stopCount.incrementAndGet();
        if (this.launcherFuture != null) {
            this.launcherFuture.cancel(true);
        }
    }
}

