/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.bracketmatching;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.source.DefaultCharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.xtext.ide.editor.bracketmatching.BracePair;
import org.eclipse.xtext.ide.editor.bracketmatching.IBracePairProvider;
import org.eclipse.xtext.xbase.lib.Conversions;

public class BracePairMatcher
implements ICharacterPairMatcher {
    private DefaultCharacterPairMatcher characterPairMatcher;

    @Inject
    public void setBracePairProvider(IBracePairProvider bracePairProvider) {
        List<Character> chars = this.getChars(bracePairProvider);
        this.characterPairMatcher = new DefaultCharacterPairMatcher((char[])Conversions.unwrapArray(chars, Character.TYPE));
    }

    protected List<Character> getChars(IBracePairProvider bracePairProvider) {
        ArrayList<Character> chars = new ArrayList<Character>();
        for (BracePair pair : bracePairProvider.getPairs()) {
            if (pair.getLeftBrace().length() == 1 && pair.getRightBrace().length() == 1) {
                chars.add(Character.valueOf(pair.getLeftBrace().charAt(0)));
                chars.add(Character.valueOf(pair.getRightBrace().charAt(0)));
                continue;
            }
            throw new IllegalStateException("Brace pair is invalid: " + String.valueOf(pair) + "; left and right braces should have length of one character.");
        }
        return chars;
    }

    public void dispose() {
        this.characterPairMatcher.dispose();
    }

    public void clear() {
        this.characterPairMatcher.clear();
    }

    public IRegion match(IDocument document, int offset) {
        return this.characterPairMatcher.match(document, offset);
    }

    public int getAnchor() {
        return this.characterPairMatcher.getAnchor();
    }
}

