/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.mwe;

import com.google.common.collect.Lists;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.WorkflowComponent;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.xtext.mwe.AbstractReader;
import org.eclipse.xtext.resource.XtextResourceSet;

public class UriBasedReader
extends AbstractReader {
    private List<String> uris = Lists.newArrayList();
    private List<URI> uris2 = Lists.newArrayList();

    public void addUri(String uri) {
        this.uris.add(uri);
    }

    @Override
    protected void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this.uris.isEmpty()) {
            issues.addError((WorkflowComponent)this, "No resource uri configured (property 'uri')");
        }
        for (String uri : this.uris) {
            try {
                this.uris2.add(URI.createURI((String)uri));
            }
            catch (Exception e) {
                issues.addError((WorkflowComponent)this, "Invalid URI '" + uri + "' (" + e.getMessage() + ")");
            }
        }
    }

    protected void invokeInternal(WorkflowContext ctx, ProgressMonitor monitor, Issues issues) {
        ResourceSet resourceSet = this.getResourceSet();
        for (URI uri : this.uris2) {
            int numberResources;
            Resource resource = resourceSet.getResource(uri, true);
            do {
                numberResources = resourceSet.getResources().size();
                EcoreUtil.resolveAll((Resource)resource);
            } while (numberResources != resourceSet.getResources().size());
        }
        this.getValidator().validate(resourceSet, this.getRegistry(), issues);
        this.addModelElementsToContext(ctx, resourceSet);
    }

    public void setClasspathURIContext(Object class1) {
        final XtextResourceSet resourceSet = new XtextResourceSet();
        resourceSet.setClasspathURIContext(class1);
        this.setResourceSetProvider(new Provider<ResourceSet>(){

            public ResourceSet get() {
                return resourceSet;
            }
        });
    }
}

