/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.oomph.targlets.internal.ui.TargletsUIPlugin;
import org.eclipse.oomph.targlets.internal.ui.wizards.Messages;
import org.eclipse.oomph.targlets.internal.ui.wizards.TargetDefinitionExportWizardPage;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class TargetDefinitionExportWizard
extends Wizard
implements IExportWizard {
    public static final String TITLE = Messages.TargetDefinitionExportWizard_title;
    private TargetDefinitionExportWizardPage page;

    public TargetDefinitionExportWizard() {
        this.setWindowTitle(TITLE);
        this.setDefaultPageImageDescriptor(TargletsUIPlugin.INSTANCE.getImageDescriptor("target_wiz.png"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.page = new TargetDefinitionExportWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final ITargetDefinition targetDefinition = this.page.getTargetDefinition();
        final File exportFolder = this.page.getExportFolder();
        new Job(Messages.TargetDefinitionExportWizard_exportTargetJob_name){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        boolean needsResolution = !targetDefinition.isResolved();
                        monitor.beginTask("", needsResolution ? 2 : 1);
                        if (needsResolution) {
                            targetDefinition.resolve((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                        }
                        this.copy((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                    }
                    catch (Exception ex) {
                        IStatus iStatus = TargletsUIPlugin.INSTANCE.getStatus(ex);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            private void copy(IProgressMonitor monitor) {
                TargetFeature[] features = targetDefinition.getAllFeatures();
                int featuresCount = features != null ? features.length : 0;
                TargetBundle[] bundles = targetDefinition.getAllBundles();
                int bundlesCount = bundles != null ? bundles.length : 0;
                monitor.beginTask("", featuresCount + bundlesCount);
                try {
                    String source;
                    int n;
                    int n2;
                    TargetFeature[] targetFeatureArray;
                    if (featuresCount != 0) {
                        targetFeatureArray = features;
                        n2 = features.length;
                        n = 0;
                        while (n < n2) {
                            TargetFeature feature = targetFeatureArray[n];
                            TargletsUIPlugin.checkCancelation((IProgressMonitor)monitor);
                            source = feature.getLocation();
                            monitor.subTask(source);
                            this.copy(source, new File(exportFolder, "features"));
                            monitor.worked(1);
                            ++n;
                        }
                    }
                    if (bundlesCount != 0) {
                        targetFeatureArray = bundles;
                        n2 = bundles.length;
                        n = 0;
                        while (n < n2) {
                            TargetFeature bundle = targetFeatureArray[n];
                            TargletsUIPlugin.checkCancelation((IProgressMonitor)monitor);
                            source = bundle.getBundleInfo().getLocation().getPath();
                            monitor.subTask(source);
                            this.copy(source, new File(exportFolder, "plugins"));
                            monitor.worked(1);
                            ++n;
                        }
                    }
                }
                finally {
                    monitor.done();
                }
            }

            private void copy(String source, File target) {
                File sourceFile = new File(source);
                File targetFile = new File(target, sourceFile.getName());
                IOUtil.copyTree((File)sourceFile, (File)targetFile);
            }
        }.schedule();
        return true;
    }
}

