/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.dialogs.filteredtree;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.ui.dialogs.filteredtree.BasicUIJob;
import org.eclipse.e4.ui.dialogs.filteredtree.PatternFilter;
import org.eclipse.e4.ui.dialogs.textbundles.E4DialogMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AbstractFilteredViewerComposite;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class FilteredTable
extends AbstractFilteredViewerComposite<PatternFilter> {
    private TableViewer tableViewer;
    private Job refreshJob;
    private Composite tableComposite;
    private static final long DEFAULT_REFRESH_TIME = 200L;

    public FilteredTable(Composite parent, int tableStyle, PatternFilter filter, long refreshDelayTime) {
        super(parent, 0, refreshDelayTime);
        this.parent = this.getParent();
        this.init(tableStyle, filter);
    }

    public FilteredTable(Composite parent, int tableStyle, PatternFilter filter) {
        this(parent, tableStyle, filter, 200L);
    }

    protected FilteredTable(Composite parent) {
        super(parent, 0, 200L);
    }

    protected void init(int tableStyle, PatternFilter filter) {
        this.setShowFilterControls(true);
        super.init(tableStyle, (ViewerFilter)filter);
        this.createRefreshJob();
        this.setInitialText(E4DialogMessages.FilteredTable_FilterMessage);
    }

    protected void createControl(Composite parent, int tableStyle) {
        super.createControl(parent, tableStyle);
        this.tableComposite = new Composite((Composite)this, 0);
        GridLayout tableCompositeLayout = new GridLayout();
        tableCompositeLayout.marginHeight = 0;
        tableCompositeLayout.marginWidth = 0;
        this.tableComposite.setLayout((Layout)tableCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.tableComposite.setLayoutData((Object)data);
        this.createTableControl(this.tableComposite, tableStyle);
    }

    protected Control createTableControl(Composite parent, int style) {
        this.tableViewer = this.doCreateTableViewer(parent, style);
        this.tableViewer.setUseHashlookup(true);
        GridData data = new GridData(4, 4, true, true);
        this.tableViewer.getControl().setLayoutData((Object)data);
        this.tableViewer.getControl().addDisposeListener(e -> {
            boolean bl = this.refreshJob.cancel();
        });
        if (this.tableViewer instanceof NotifyingTableViewer) {
            this.getPatternFilter().setUseCache(true);
        }
        this.tableViewer.addFilter((ViewerFilter)this.getPatternFilter());
        return this.tableViewer.getControl();
    }

    protected TableViewer doCreateTableViewer(Composite parent, int style) {
        return new NotifyingTableViewer(parent, style);
    }

    private TableItem getFirstMatchingItem(TableItem[] items) {
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (this.getPatternFilter().isLeafMatch((Viewer)this.tableViewer, item.getData()) && this.getPatternFilter().isElementSelectable(item.getData())) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    protected Job doCreateRefreshJob() {
        return new BasicUIJob("Refresh Filter", this.getDisplay()){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTable.this.tableViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = FilteredTable.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = FilteredTable.this.initialText != null && FilteredTable.this.initialText.equals(text);
                if (initial) {
                    FilteredTable.this.getPatternFilter().setPattern(null);
                } else if (text != null) {
                    FilteredTable.this.getPatternFilter().setPattern(text);
                }
                FilteredTable.this.tableViewer.refresh(true);
                return Status.OK_STATUS;
            }
        };
    }

    protected void createFilterText(Composite parent) {
        super.createFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTable.this.filterText.getText();
                e.result = filterTextString.isEmpty() || filterTextString.equals(FilteredTable.this.initialText) ? FilteredTable.this.initialText : NLS.bind((String)E4DialogMessages.FilteredTable_AccessibleListenerFiltered, (Object[])new String[]{filterTextString, String.valueOf(this.getFilteredItemsCount())});
            }

            private int getFilteredItemsCount() {
                return FilteredTable.this.getViewer().getTable().getItems().length;
            }
        });
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = FilteredTable.this.getViewer().getTable().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    FilteredTable.this.tableViewer.getTable().setFocus();
                    return;
                }
            }
        });
        this.filterText.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                if (this.getViewer().getTable().getItemCount() == 0) {
                    Display.getCurrent().beep();
                } else {
                    Table table;
                    TableItem item;
                    boolean textChanged;
                    boolean hasFocus = this.getViewer().getTable().setFocus();
                    boolean bl = textChanged = !this.getInitialText().equals(this.filterText.getText().trim());
                    if (hasFocus && textChanged && this.filterText.getText().trim().length() > 0 && (item = (table = this.getViewer().getTable()).getSelectionCount() > 0 ? this.getFirstMatchingItem(table.getSelection()) : this.getFirstMatchingItem(table.getItems())) != null) {
                        table.setSelection(new TableItem[]{item});
                        ISelection sel = this.getViewer().getSelection();
                        this.getViewer().setSelection(sel, true);
                    }
                }
            }
        });
    }

    protected Text doCreateFilterText(Composite parent) {
        return new Text(parent, 2948);
    }

    protected void textChanged() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null) {
            this.filterComposite.setBackground(background);
        }
    }

    public final PatternFilter getPatternFilter() {
        return (PatternFilter)super.getPatternFilter();
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public static Font getBoldFont(Object element, FilteredTable table, PatternFilter filter) {
        String filterText = table.getFilterString();
        if (filterText == null) {
            return null;
        }
        String initialText = table.getInitialText();
        if (!filterText.isEmpty() && !filterText.equals(initialText)) {
            if (table.getPatternFilter() != filter) {
                boolean initial;
                boolean bl = initial = initialText != null && initialText.equals(filterText);
                if (initial) {
                    filter.setPattern(null);
                } else if (filterText != null) {
                    filter.setPattern(filterText);
                }
            }
            if (filter.isElementVisible((Viewer)table.getViewer(), element) && filter.isLeafMatch((Viewer)table.getViewer(), element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }

    public boolean isShowFilterControls() {
        return this.showFilterControls;
    }

    public void setShowFilterControls(boolean showFilterControls) {
        this.showFilterControls = showFilterControls;
        if (this.filterComposite != null) {
            Object filterCompositeLayoutData = this.filterComposite.getLayoutData();
            if (filterCompositeLayoutData instanceof GridData) {
                ((GridData)filterCompositeLayoutData).exclude = !this.isShowFilterControls();
            } else if (filterCompositeLayoutData instanceof RowData) {
                ((RowData)filterCompositeLayoutData).exclude = !this.isShowFilterControls();
            }
            this.filterComposite.setVisible(this.isShowFilterControls());
            this.layout();
        }
    }

    class NotifyingTableViewer
    extends TableViewer {
        public NotifyingTableViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object element) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.add(element);
        }

        public void add(Object[] elements) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.add(elements);
        }

        protected void inputChanged(Object input, Object oldInput) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object element, int position) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.insert(element, position);
        }

        public void refresh() {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.refresh();
        }

        public void refresh(boolean updateLabels) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.refresh(updateLabels);
        }

        public void refresh(Object element) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.refresh(element);
        }

        public void refresh(Object element, boolean updateLabels) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.refresh(element, updateLabels);
        }

        public void remove(Object element) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.remove(element);
        }

        public void remove(Object[] elements) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.remove(elements);
        }

        public void replace(Object element, int index) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.replace(element, index);
        }

        public void setContentProvider(IContentProvider provider) {
            FilteredTable.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }
    }
}

