/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property;

import java.util.Set;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.set.SetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.core.internal.databinding.property.PropertyObservableUtil;

public class ValuePropertyDetailSet<S, M, T>
extends SetProperty<S, T> {
    private IValueProperty<S, M> masterProperty;
    private ISetProperty<? super M, T> detailProperty;

    public ValuePropertyDetailSet(IValueProperty<S, M> masterProperty, ISetProperty<? super M, T> detailProperty) {
        this.masterProperty = masterProperty;
        this.detailProperty = detailProperty;
    }

    @Override
    public Object getElementType() {
        return this.detailProperty.getElementType();
    }

    @Override
    protected Set<T> doGetSet(S source) {
        M masterValue = this.masterProperty.getValue(source);
        return this.detailProperty.getSet(masterValue);
    }

    @Override
    protected void doSetSet(S source, Set<T> set) {
        M masterValue = this.masterProperty.getValue(source);
        this.detailProperty.setSet(masterValue, set);
    }

    @Override
    protected void doUpdateSet(S source, SetDiff<T> diff) {
        M masterValue = this.masterProperty.getValue(source);
        this.detailProperty.updateSet(masterValue, diff);
    }

    @Override
    public IObservableSet<T> observe(Realm realm, S source) {
        IObservableValue<M> masterValue;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterValue = this.masterProperty.observe(realm, source);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableSet<T> detailSet = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose(detailSet, masterValue);
        return detailSet;
    }

    @Override
    public <U extends S> IObservableSet<T> observeDetail(IObservableValue<U> master) {
        IObservableValue<M> masterValue;
        ObservableTracker.setIgnore((boolean)true);
        try {
            masterValue = this.masterProperty.observeDetail(master);
        }
        finally {
            ObservableTracker.setIgnore((boolean)false);
        }
        IObservableSet<T> detailSet = this.detailProperty.observeDetail(masterValue);
        PropertyObservableUtil.cascadeDispose(detailSet, masterValue);
        return detailSet;
    }

    public String toString() {
        return String.valueOf(this.masterProperty) + " => " + String.valueOf(this.detailProperty);
    }
}

