/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.Activator;

public abstract class CancelableFuture<V> {
    private State state = State.PRISTINE;
    private V result;
    private InterruptibleJob job;

    public synchronized boolean cancel(CancelMode cancellation) {
        CancelMode mode = cancellation == null ? CancelMode.CANCEL : cancellation;
        switch (this.state) {
            case PRISTINE: {
                this.finish(false);
                return true;
            }
            case SCHEDULED: {
                this.state = State.CANCELING;
                boolean canceled = this.job.cancel();
                if (canceled) {
                    this.state = State.CANCELED;
                } else if (mode == CancelMode.INTERRUPT) {
                    this.interrupt();
                } else if (mode == CancelMode.ABANDON) {
                    this.notifyAll();
                }
                return canceled;
            }
            case CANCELING: {
                if (mode == CancelMode.INTERRUPT) {
                    this.interrupt();
                } else if (mode == CancelMode.ABANDON) {
                    this.notifyAll();
                }
                return false;
            }
            case INTERRUPT: {
                if (mode != CancelMode.CANCEL) {
                    this.notifyAll();
                }
                return false;
            }
            case CANCELED: {
                return true;
            }
        }
        return false;
    }

    public synchronized boolean isFinished() {
        return this.state == State.CANCELED || this.state == State.DONE;
    }

    public synchronized boolean isDone() {
        return this.state == State.DONE;
    }

    public synchronized V get() throws InterruptedException, InvocationTargetException {
        switch (this.state) {
            case CANCELED: 
            case DONE: {
                return this.result;
            }
            case PRISTINE: {
                this.start();
                return this.get();
            }
        }
        this.wait();
        if (this.state == State.CANCELING || this.state == State.INTERRUPT) {
            throw new InterruptedException();
        }
        return this.get();
    }

    private synchronized void finish(boolean done) {
        this.state = done ? State.DONE : State.CANCELED;
        this.job = null;
        try {
            this.done();
        }
        finally {
            this.notifyAll();
        }
    }

    private synchronized void interrupt() {
        this.state = State.INTERRUPT;
        this.job.interrupt();
        this.notifyAll();
    }

    protected void set(V value) {
        this.result = value;
    }

    protected void prepareRun() throws InvocationTargetException {
    }

    protected String getJobTitle() {
        return "";
    }

    protected abstract void run(IProgressMonitor var1) throws InterruptedException, InvocationTargetException;

    protected void done() {
    }

    public synchronized void start() throws InvocationTargetException {
        if (this.job != null || this.state != State.PRISTINE) {
            return;
        }
        try {
            this.prepareRun();
        }
        catch (InvocationTargetException e) {
            this.finish(false);
            throw e;
        }
        this.job = new InterruptibleJob(this.getJobTitle()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CancelableFuture.this.run(monitor);
                    return Status.OK_STATUS;
                }
                catch (InterruptedException e) {
                    return Status.CANCEL_STATUS;
                }
                catch (InvocationTargetException e) {
                    CancelableFuture cancelableFuture = CancelableFuture.this;
                    synchronized (cancelableFuture) {
                        if (CancelableFuture.this.state == State.CANCELING || CancelableFuture.this.state == State.INTERRUPT) {
                            return Status.CANCEL_STATUS;
                        }
                    }
                    return Activator.createErrorStatus(e.getLocalizedMessage(), e);
                }
                catch (RuntimeException e) {
                    return Activator.createErrorStatus(e.getLocalizedMessage(), e);
                }
            }
        };
        this.job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IStatus status = event.getResult();
                CancelableFuture.this.finish(status != null && status.isOK());
            }
        });
        this.job.setUser(false);
        this.job.setSystem(true);
        this.state = State.SCHEDULED;
        this.job.schedule();
    }

    public static enum CancelMode {
        CANCEL,
        ABANDON,
        INTERRUPT;

    }

    private static abstract class InterruptibleJob
    extends Job {
        public InterruptibleJob(String name) {
            super(name);
        }

        public void interrupt() {
            Thread thread = this.getThread();
            if (thread != null) {
                thread.interrupt();
            }
        }
    }

    private static enum State {
        PRISTINE,
        SCHEDULED,
        CANCELING,
        INTERRUPT,
        CANCELED,
        DONE;

    }
}

